unit uCheckBox;

interface

uses Rubies, QStdCtrls;

var
  cCheckBox: Tvalue;

function ap_cCheckBox: Tvalue; stdcall;
procedure CheckBox_setup(obj: Tvalue; real: TCheckBox);
function CheckBox_alloc(This: Tvalue; real: TCheckBox): Tvalue; stdcall;
procedure Init_CheckBox;

implementation

uses
  Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uComponent, uControl, uButton;

function ap_cCheckBox: Tvalue; stdcall;
begin
  result := cCheckBox;
end;

procedure CheckBox_setup(obj: Tvalue; real: TCheckBox);
begin
  AssignPropMethod(real, [Handle]);
end;

function CheckBox_alloc(This: Tvalue; real: TCheckBox): Tvalue; stdcall;
begin
  result := ChildAlloc(This, real);
  CheckBox_setup(result, real);
end;

function CheckBox_alloc_v(var AControl): Tvalue;
begin
  result := CheckBox_alloc(ap_cCheckBox, TCheckBox(AControl))
end;

function CheckBox_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TCheckBox;
begin
  real := TCheckBox.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  CheckBox_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function CheckBox_set_caption(This, v: Tvalue): Tvalue; cdecl;
var
  real: TCheckBox;
begin
  real := ap_data_get_struct(This);
  real.caption := STR2CSTR(v);
  result := v;
end;

procedure Init_CheckBox;
begin
  cCheckBox := DefineCompoClass(mPhi, TCheckBox, cButton, CheckBox_alloc_v);
  DefineSingletonMethod(cCheckBox, 'new', CheckBox_new);
  DefineAttrSet(cCheckBox, 'caption', CheckBox_set_caption);
end;

exports
  ap_cCheckBox,
  CheckBox_alloc;

end.
