unit uCanvas;

interface

uses QGraphics, Rubies;

var
  cCanvas: Tvalue;

function ap_cCanvas: Tvalue; stdcall;
procedure Canvas_setup(obj: Tvalue; real: TCanvas);
function Canvas_alloc(This: Tvalue; real: TCanvas): Tvalue; stdcall;
procedure Init_Canvas;

implementation

uses
  SysUtils, Types,
  uIntern, uAlloc, uProp, uPhi,
  uFont, uBrush, uPen, uRect, uSize;

function ap_cCanvas: Tvalue; stdcall;
begin
  result := cCanvas;
end;

procedure Canvas_setup(obj: Tvalue; real: TCanvas);
begin
  rb_iv_set(obj, '@font', Font_alloc(cFont, real.Font));
  rb_iv_set(obj, '@brush', Brush_alloc(cBrush, real.Brush));
  rb_iv_set(obj, '@pen', Pen_alloc(cPen, real.Pen));
end;

function Canvas_alloc(This: Tvalue; real: TCanvas): Tvalue; stdcall;
begin
  result := TmpAlloc(This, real);
  Canvas_setup(result, real);
end;

function Canvas_new(This: Tvalue): Tvalue; cdecl;
var
  real: TCanvas;
begin
  real := TCanvas.Create;
  result := ObjAlloc(This, real);
  Canvas_setup(result, real);
  rb_obj_call_init(result, 0, nil);
end;

function Canvas_clip_rect(This: Tvalue): Tvalue; cdecl;
var
  real: TCanvas;
begin
  real := ap_data_get_struct(This);
  result := Rect_alloc(cRect, real.ClipRect);
end;

function Canvas_copy_rect(This, dst, cv, src: Tvalue): Tvalue; cdecl;
var
  real: TCanvas;
  Dest: TRect;
  Canvas: TCanvas;
  Source: TRect;
begin
  real := ap_data_get_struct(This);
  Dest := PRect(ap_data_get_struct(dst))^;
  ap_data_get_object(cv, TCanvas, Canvas);
  Source := PRect(ap_data_get_struct(src))^;
  real.CopyRect(Dest, Canvas, Source);
  result := This;
end;

function Canvas_fill_rect(This, vrect: Tvalue): Tvalue; cdecl;
var
  real: TCanvas;
  rect: TRect;
begin
  real := ap_data_get_struct(This);
  rect := PRect(ap_data_get_struct(vrect))^;
  real.FillRect(rect);
  result := Qnil;
end;

function Canvas_text_extent(This, str: Tvalue): Tvalue; cdecl;
var
  real: TCanvas;
begin
  real := ap_data_get_struct(This);
  result := Size_alloc(ap_cSize, real.TextExtent(STR2CSTR(str)));
end;

function Canvas_text_width(This, str: Tvalue): Tvalue; cdecl;
var
  real: TCanvas;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.TextWidth(STR2CSTR(str)));
end;

function Canvas_text_height(This, str: Tvalue): Tvalue; cdecl;
var
  real: TCanvas;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.TextHeight(STR2CSTR(str)));
end;

function Canvas_text_out(This, x, y, str: Tvalue): Tvalue; cdecl;
var
  real: TCanvas;
begin
  real := ap_data_get_struct(This);
  real.TextOut(FIX2INT(x), FIX2INT(y), STR2CSTR(str));
  result := Qnil;
end;

function Canvas_text_rect(This, vrect, x, y, str: Tvalue): Tvalue; cdecl;
var
  real: TCanvas;
  rect: TRect;
begin
  real := ap_data_get_struct(This);
  rect := PRect(ap_data_get_struct(vrect))^;
  real.TextRect(rect, FIX2INT(x), FIX2INT(y), STR2CSTR(str));
  result := Qnil;
end;

function Canvas_draw(This, x, y, vgraphic: Tvalue): Tvalue; cdecl;
var
  real: TCanvas;
  graphic: TGraphic;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(vgraphic, TGraphic, graphic);
  real.Draw(FIX2INT(x), FIX2INT(y), graphic);
  result := Qnil;
end;

function Canvas_stretch_draw(This, vrect, vgraphic: Tvalue): Tvalue; cdecl;
var
  real: TCanvas;
  rect: TRect;
  graphic: TGraphic;
begin
  real := ap_data_get_struct(This);
  rect := PRect(ap_data_get_struct(vrect))^;
  ap_data_get_object(vgraphic, TGraphic, graphic);
  real.StretchDraw(rect, graphic);
  result := Qnil;
end;

function Canvas_draw_focus_rect(This, vrect: Tvalue): Tvalue; cdecl;
var
  real: TCanvas;
  rect: TRect;
begin
  real := ap_data_get_struct(This);
  rect := PRect(ap_data_get_struct(vrect))^;
  real.DrawFocusRect(rect);
  result := Qnil;
end;

function Canvas_ellipse(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  args: array of Tvalue;
  real: TCanvas;
  rect: TRect;
  x1, y1, x2, y2: Integer;
begin
  SetLength(args, argc);
  args := argv;
  real := ap_data_get_struct(This);
  case RTYPE(args[0]) of
  T_DATA:
    begin
      if argc <> 1 then ap_raise(ap_eArgError, sWrong_num_of_args);
      rect := PRect(ap_data_get_struct(args[0]))^;
      x1 := rect.Left;
      y1 := rect.Top;
      x2 := rect.Right;
      y2 := rect.Bottom;
    end;
  T_FIXNUM:
    begin
      if argc <> 4 then ap_raise(ap_eArgError, sWrong_num_of_args);
      x1 := FIX2INT(args[0]);
      y1 := FIX2INT(args[1]);
      x2 := FIX2INT(args[2]);
      y2 := FIX2INT(args[3]);
    end;
  else
    ap_raise(ap_eArgError, sWrong_arg_type);
    x1 := 0;
    y1 := 0;
    x2 := 0;
    y2 := 0;
  end;
  real.Ellipse(x1, y1, x2, y2);
  result := Qnil;
end;

function Canvas_rectangle(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  args: array of Tvalue;
  real: TCanvas;
  rect: TRect;
  x1, y1, x2, y2: Integer;
begin
  SetLength(args, argc);
  args := argv;
  real := ap_data_get_struct(This);
  case RTYPE(args[0]) of
  T_DATA:
    begin
      if argc <> 1 then ap_raise(ap_eArgError, sWrong_num_of_args);
      rect := PRect(ap_data_get_struct(args[0]))^;
      x1 := rect.Left;
      y1 := rect.Top;
      x2 := rect.Right;
      y2 := rect.Bottom;
    end;
  T_FIXNUM:
    begin
      if argc <> 4 then ap_raise(ap_eArgError, sWrong_num_of_args);
      x1 := FIX2INT(args[0]);
      y1 := FIX2INT(args[1]);
      x2 := FIX2INT(args[2]);
      y2 := FIX2INT(args[3]);
    end;
  else
    ap_raise(ap_eArgError, sWrong_arg_type);
    x1 := 0;
    y1 := 0;
    x2 := 0;
    y2 := 0;
  end;
  real.Rectangle(x1, y1, x2, y2);
  result := Qnil;
end;

function Canvas_round_rect(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  args: array of Tvalue;
  real: TCanvas;
  rect: TRect;
  x1, y1, x2, y2, x3, y3: Integer;
begin
  SetLength(args, argc);
  args := argv;
  real := ap_data_get_struct(This);
  case RTYPE(args[0]) of
  T_DATA:
    begin
      if argc <> 3 then ap_raise(ap_eArgError, sWrong_num_of_args);
      rect := PRect(ap_data_get_struct(args[0]))^;
      x1 := rect.Left;
      y1 := rect.Top;
      x2 := rect.Right;
      y2 := rect.Bottom;
      x3 := FIX2INT(args[1]);
      y3 := FIX2INT(args[2]);
    end;
  T_FIXNUM:
    begin
      if argc <> 6 then ap_raise(ap_eArgError, sWrong_num_of_args);
      x1 := FIX2INT(args[0]);
      y1 := FIX2INT(args[1]);
      x2 := FIX2INT(args[2]);
      y2 := FIX2INT(args[3]);
      x3 := FIX2INT(args[4]);
      y3 := FIX2INT(args[5]);
    end;
  else
    ap_raise(ap_eArgError, sWrong_arg_type);
    x1 := 0;
    y1 := 0;
    x2 := 0;
    y2 := 0;
    x3 := 0;
    y3 := 0;
  end;
  real.RoundRect(x1, y1, x2, y2, x3, y3);
  result := Qnil;
end;

function Canvas_aref(This, x, y: Tvalue): Tvalue; cdecl;
begin
  result := Qnil;
end;

function Canvas_aset(This, x, y, color: Tvalue): Tvalue; cdecl;
begin
  result := Qnil;
end;

function Canvas_flood_fill(This, x, y, color, style: Tvalue): Tvalue; cdecl;
begin
  result := Qnil;
end;

function Canvas_move_to(This, x, y: Tvalue): Tvalue; cdecl;
var
  real: TCanvas;
begin
  real := ap_data_get_struct(This);
  real.MoveTo(FIX2INT(x), FIX2INT(y));
  result := Qnil;
end;

function Canvas_line_to(This, x, y: Tvalue): Tvalue; cdecl;
var
  real: TCanvas;
begin
  real := ap_data_get_struct(This);
  real.LineTo(FIX2INT(x), FIX2INT(y));
  result := Qnil;
end;

function Canvas_set_pen_pos(This, v: Tvalue): Tvalue; cdecl;
var
  real: TCanvas;
begin
  real := ap_data_get_struct(This);
  real.PenPos := PPoint(ap_data_get_struct(v))^;
  result := v;
end;

function Canvas_lock(This: Tvalue): Tvalue; cdecl;
var
  real: TCanvas;
begin
  real := ap_data_get_struct(This);
  real.Lock;
  try
    result := rb_yield(Qnil);
  finally
    real.Unlock;
  end;
end;

procedure Init_Canvas;
begin
  DefineConstSetType(mPhi, TypeInfo(TCanvasStates));

  cCanvas := rb_define_class_under(mPhi, 'Canvas', ap_cObject);
  DefineProp(cCanvas, TCanvas);

  rb_define_singleton_method(cCanvas, 'new', @Canvas_new, 0);
  rb_define_method(cCanvas, 'clip_rect', @Canvas_clip_rect, 0);
  rb_define_method(cCanvas, 'copy_rect', @Canvas_copy_rect, 3);
  rb_define_method(cCanvas, 'fill_rect', @Canvas_fill_rect, 1);
  rb_define_method(cCanvas, 'text_extent', @Canvas_text_extent, 1);
  rb_define_method(cCanvas, 'text_width', @Canvas_text_width, 1);
  rb_define_method(cCanvas, 'text_height', @Canvas_text_height, 1);
  rb_define_method(cCanvas, 'text_out', @Canvas_text_out, 3);
  rb_define_method(cCanvas, 'text_rect', @Canvas_text_rect, 4);
  rb_define_method(cCanvas, 'draw', @Canvas_draw, 3);
  rb_define_method(cCanvas, 'stretch_draw', @Canvas_stretch_draw, 2);
  rb_define_method(cCanvas, 'draw_focus_rect', @Canvas_draw_focus_rect, 1);
  DefineMethod(cCanvas, 'ellipse', Canvas_ellipse);
  rb_define_alias(cCanvas, 'draw_oval', 'ellipse');
  DefineMethod(cCanvas, 'rectangle', Canvas_rectangle);
  rb_define_alias(cCanvas, 'draw_rect', 'rectangle');
  DefineMethod(cCanvas, 'round_rect', Canvas_round_rect);
  // vcl: pixels
  rb_define_method(cCanvas, '[]', @Canvas_aref, 2);
  rb_define_method(cCanvas, '[]=', @Canvas_aset, 3);
  rb_define_method(cCanvas, 'flood_fill', @Canvas_flood_fill, 4);
  rb_define_method(cCanvas, 'move_to', @Canvas_move_to, 2);
  rb_define_method(cCanvas, 'line_to', @Canvas_line_to, 2);
  rb_define_method(cCanvas, 'lock', @Canvas_lock, 0);
end;

exports
  ap_cCanvas,
  Canvas_alloc;

end.
