unit uButton;

interface

uses Rubies, QStdCtrls;

var
  cButton: Tvalue;

function ap_cButton: Tvalue; stdcall;
procedure Button_setup(obj: Tvalue; real: TButton);
function Button_alloc(This: Tvalue; real: TButton): Tvalue; stdcall;
procedure Init_Button;

implementation

uses
  Classes,
  uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uComponent, uControl;

function ap_cButton: Tvalue; stdcall;
begin
  result := cButton;
end;

procedure Button_setup(obj: Tvalue; real: TButton);
begin
  rb_iv_set(obj, '@constraints', SizeConstraints_alloc(cSizeConstraints, real.Constraints));
  AssignPropMethod(real, [Handle]);
end;

function Button_alloc(This: Tvalue; real: TButton): Tvalue; stdcall;
begin
  result := ChildAlloc(This, real);
  Button_setup(result, real);
end;

function Button_alloc_v(var AControl): Tvalue;
begin
  result := Button_alloc(cButton, TButton(AControl));
end;

function Button_new(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TButton;
begin
  real := TButton.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  Button_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function Button_click(This: Tvalue):Tvalue; cdecl;
var
  real:TButton;
begin
  real := ap_data_get_struct(This);
  real.click;
  result := This;
end;

procedure Init_button;
begin
  cButton := DefineCompoClass(mPhi, TButton, cWinControl, Button_alloc_v);
  DefineSingletonMethod(cButton, 'new', Button_new);
  rb_define_method(cButton, 'click', @Button_click, 0);
end;

exports
  ap_cButton,
  Button_setup,
  Button_alloc;

end.
