unit uBrush;

interface

uses QGraphics, Rubies;

var
  cBrush: Tvalue;

function ap_cBrush: Tvalue; stdcall;
procedure Brush_setup(obj: Tvalue; real: TBrush);
function Brush_alloc(This: Tvalue; real: TBrush): Tvalue; stdcall;
procedure Init_Brush;

implementation

uses
  Classes,
  uIntern, uAlloc, uProp, uPhi,
  uStrings;

function ap_cBrush: Tvalue; stdcall;
begin
  result := cBrush;
end;

procedure Brush_setup(obj: Tvalue; real: TBrush);
begin
//  rb_iv_set(obj, '@bitmap', Bitmap_alloc(cBitmap, real.Bitmap));
end;

function Brush_alloc(This: Tvalue; real: TBrush): Tvalue; stdcall;
begin
  result := TmpAlloc(This, real);
  Brush_setup(result, real);
end;

function Brush_new(This: Tvalue): Tvalue; cdecl;
var
  real: TBrush;
begin
  real := TBrush.Create;
  result := ObjAlloc(This, real);
  Brush_setup(result, real);
  rb_obj_call_init(result, 0, nil);
end;

function Brush_assign(This, v: Tvalue): Tvalue; cdecl;
var
  real: TBrush;
  source: TPersistent;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TPersistent, source);
  real.Assign(source);
  result := v;
end;

procedure Init_Brush;
begin
  DefineConstSetType(mPhi, TypeInfo(TBrushStyle));

  cBrush := rb_define_class_under(mPhi, 'Brush', ap_cObject);
  DefineProp(cBrush, TBrush);

  rb_define_singleton_method(cBrush, 'new', @Brush_new, 0);
  rb_define_method(cStrings, 'assign', @Brush_assign, 1);
end;

exports
  ap_cBrush,
  Brush_alloc;

end.
