unit uApplication;

interface

uses Rubies, QForms;

var
  cApplication: Tvalue;
  vApplication: Tvalue;

function ap_cApplication: Tvalue; stdcall;
procedure Init_Application;

implementation

uses QGraphics, uStrUtils, uAlloc, uProp, uPhi, uConv, uIO, uIcon;

function ap_cApplication: Tvalue; stdcall;
begin
  result := cApplication;
end;

function Application_handle_message(This: Tvalue): Tvalue; cdecl;
var
  real: TApplication;
begin
  real := ap_data_get_struct(This);
  real.HandleMessage;
  result := Qnil;
end;

function Application_process_messages(This: Tvalue): Tvalue; cdecl;
var
  real: TApplication;
begin
  real := ap_data_get_struct(This);
  real.ProcessMessages;
  result := Qnil;
end;

function Application_get_terminated(This: Tvalue): Tvalue; cdecl;
var
  real: TApplication;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.Terminated);
end;

function Application_set_icon(This, v: Tvalue): Tvalue; cdecl;
var
  real: TApplication;
  icon: TIcon;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TIcon, icon);
  real.Icon := icon;
  result := v;
  rb_iv_set(This, '@icon', v);
end;

function Application_set_title(This, v: Tvalue): Tvalue; cdecl;
var
  real: TApplication;
begin
  real := ap_data_get_struct(This);
  real.Title := STR2CSTR(v);
  result := v;
  rb_iv_set(This, '@title', v);
end;

function Application_get_show_hint(This: Tvalue): Tvalue; cdecl;
var
  real: TApplication;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.ShowHint);
end;

function Application_set_show_hint(This, v: Tvalue): Tvalue; cdecl;
var
  real: TApplication;
begin
  real := ap_data_get_struct(This);
  real.ShowHint := dl_Boolean(v);
  result := This;
end;

function Application_get_hint_color(This: Tvalue): Tvalue; cdecl;
var
  real: TApplication;
begin
  real := ap_data_get_struct(This);
  result := rb_int2inum(real.HintColor);
end;

function Application_set_hint_color(This, v: Tvalue): Tvalue; cdecl;
var
  real: TApplication;
begin
  real := ap_data_get_struct(This);
  real.HintColor := NUM2INT(v);
  result := v;
end;

function Application_instance(This: Tvalue): Tvalue; cdecl;
begin
  result := vApplication;
end;

procedure Regist_Application;
var
  real: TApplication;
  obj: Tvalue;
begin
  real := Application;
  obj := ChildAlloc(cApplication, real);
  vApplication := obj;
  rb_define_const(mPhi, 'APPLICATION', obj);
  rb_iv_set(obj, '@icon', Icon_alloc(ap_cIcon, real.Icon));
  rb_iv_set(obj, '@title', rb_str_new2(PChar(WideCharToString(PWideChar(real.Title)))));

  ap_set_stdin(obj);
  ap_set_stdout(obj);
  ap_set_stderr(obj);
  ap_set_defout(obj);
end;

procedure Init_Application;
begin
  cApplication := rb_define_class_under(mPhi, 'Application', ap_cIO);
  DefineProp(cApplication, TApplication);

  rb_undef_method(CLASS_OF(cApplication), 'new');
  rb_define_singleton_method(cApplication, 'instance', @Application_instance, 0);

  rb_define_method(ap_cApplication, 'handle_message', @Application_handle_message, 0);
  rb_define_method(ap_cApplication, 'process_messages', @Application_process_messages, 0);
  DefineAttrGet(cApplication, 'terminated', Application_get_terminated);
  DefineAttrSet(cApplication, 'icon', Application_set_icon);
  DefineAttrSet(cApplication, 'title', Application_set_title);
  rb_define_attr(cApplication, 'icon', 1, 0);
  rb_define_attr(cApplication, 'title', 1, 0);
  DefineAttrGet(cApplication, 'show_hint', Application_get_show_hint);
  DefineAttrSet(cApplication, 'show_hint', Application_set_show_hint);
  DefineAttrGet(cApplication, 'hint_color', Application_get_hint_color);
  DefineAttrSet(cApplication, 'hint_color', Application_set_hint_color);

  rb_define_method(ap_cApplication, 'write', @Phi_write, 1);
  rb_define_method(ap_cApplication, 'gets', @Phi_gets, 0);
  rb_define_method(ap_cApplication, 'getc', @Phi_getc, 0);
  rb_define_method(ap_cApplication, 'flush', @Phi_flush, 0);
  rb_define_method(ap_cApplication, 'close', @Phi_close, 0);

  Regist_Application;
end;

exports
  ap_cApplication;

end.
