unit uAlloc;

//author: YOSHIDA Kazuhiro (moriq)
//mailto: moriq@moriq.com

interface

uses Classes, QForms, Rubies;

procedure ap_dispose(p: Pointer); cdecl;
procedure ObjFree(real: TObject); cdecl;
procedure ChildFree(real: TComponent); cdecl;
procedure CompoFree(real: TComponent); cdecl;
procedure FormRelease(real: TForm); cdecl;
function CompoAlloc(klass: Tvalue; real: TComponent): Tvalue; stdcall;
function FormAlloc(klass: Tvalue; real: TComponent): Tvalue; stdcall;
function ObjAlloc(klass: Tvalue; real: TObject): Tvalue; stdcall;
function ChildAlloc(klass: Tvalue; real: TComponent): Tvalue; stdcall;
function TmpAlloc(klass: Tvalue; real: TObject): Tvalue; stdcall;

implementation

uses SysUtils, uDebug, uHandle;

procedure ap_dispose(p: Pointer); cdecl;
begin
  try
    Dispose(p);
  except
    on E: Exception do;
  end;
end;

procedure ObjFree(real: TObject); cdecl;
begin
  try
    PhiObjectList.Remove(real);
  except
    on E: Exception do;
  end;
end;

procedure ChildFree(real: TComponent); cdecl;
begin
  try
    real.tag := 0;
  except
    on E: Exception do;
  end;
end;

procedure CompoFree(real: TComponent); cdecl;
begin
  try
    real.tag := 0;
    if csDestroying in real.ComponentState then
      PhiObjectList.Extract(real)
    else
      PhiObjectList.Remove(real);
  except
    on E: Exception do;
  end;
end;

procedure FormRelease(real: TForm); cdecl;
begin
  try
    real.tag := 0;
    PhiObjectList.Extract(real);
    real.Release;
  except
    on E: Exception do;
  end;
end;

function CompoAlloc(klass: Tvalue; real: TComponent): Tvalue; stdcall;
begin
  if real = nil then begin result := Qnil; exit; end;
  PhiObjectList.Add(real);
  result := rb_data_object_alloc(klass, real, nil, @CompoFree);
  rb_iv_set(result, '@events', rb_hash_new);
  real.tag := result;
  if rb_block_given_p <> 0 then rb_obj_instance_eval(0, nil, result);
end;

function FormAlloc(klass: Tvalue; real: TComponent): Tvalue; stdcall;
begin
  if real = nil then begin result := Qnil; exit; end;
  PhiObjectList.Add(real);
  result := rb_data_object_alloc(klass, real, nil, @FormRelease);
  rb_iv_set(result, '@events', rb_hash_new);
  real.tag := result;
end;

function ObjAlloc(klass: Tvalue; real: TObject): Tvalue; stdcall;
begin
  if real = nil then begin result := Qnil; exit; end;
  PhiObjectList.Add(real);
  result := rb_data_object_alloc(klass, real, nil, @ObjFree);
end;

function ChildAlloc(klass: Tvalue; real: TComponent): Tvalue; stdcall;
begin
  if real = nil then begin result := Qnil; exit; end;
  result := rb_data_object_alloc(klass, real, nil, @ChildFree);
  rb_iv_set(result, '@events', rb_hash_new);
  real.tag := result;
end;

function TmpAlloc(klass: Tvalue; real: TObject): Tvalue; stdcall;
begin
  if real = nil then begin result := Qnil; exit; end;
  result := rb_data_object_alloc(klass, real, nil, @ObjFree);
end;

exports
  ap_dispose,
  ObjFree,
  ChildFree,
  CompoFree,
  FormRelease,
  CompoAlloc,
  FormAlloc,
  ChildAlloc,
  ObjAlloc,
  TmpAlloc;

end.
