program ruby_ap;

{$APPTYPE CONSOLE}

uses
{$IFDEF WIN32}
  Windows, ShellAPI,
{$ENDIF}
  Types, SysUtils, Rubies;

{$IFDEF WIN32}
var
  argc: Integer;
  argv: Pointer;
{$ENDIF}

begin
asm
  FInit;
end;
  ruby_init;
{$IFDEF LINUX}
  ruby_options(ArgCount, ArgValues);
{$ENDIF}
{$IFDEF WIN32}
  argv := CommandLineToArgvW(GetCommandLineW, argc);
  NTInitialize(@argc, @argv);
  ruby_options( argc,  argv);
{$ENDIF}
  try
    ruby_run;
  except
    on E: Exception do
      WriteLn(
        ap_sourcefile, ':',
        ap_sourceline, ': in `',
        rb_id2name(rb_frame_last_func), ''': ',
        E.message, ' (', E.ClassName, ')');
  end;
end.
