unit Console;

interface

uses
  Types, SysUtils, Classes, QGraphics, QControls, QForms, QDialogs,
  QStdCtrls, QExtCtrls;

type
  TFormConsole = class(TForm)
    Memo1: TMemo;
    Panel1: TPanel;
    btnClear: TButton;
    btnGC: TButton;
    LblKey: TLabel;
    lblChr: TLabel;
    procedure btnClearClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnGCClick(Sender: TObject);
    procedure Memo1KeyPress(Sender: TObject; var Key: Char);
  end;

var
  FormConsole: TFormConsole;
  StdinKey : Char = #0;
  StdinBuf : string;

procedure Stdout(S: string);
function gets: string;
function getc: Char;

implementation

uses
  Rubies,
{$IFDEF PHIEMBED}
  PhiMainUnit,
{$ELSE}
  PhiExternal,
{$ENDIF}
  Browser;

{$R *.xfm}

procedure Stdout(S: string);
var
  WStr: WideString;
begin
  with FormConsole.Memo1, Lines do
  begin
    Text := Text+S;
    WStr := Text;
    SelStart := Length(WStr)
{$IFDEF WIN32}
  +1
{$ENDIF}
    ;
    SelLength := 0;
  end;
end;

function gets: string;
var
  term_p: Boolean;
begin
  FormConsole.Show;
  term_p := False;
  repeat
    if not PhiAlive then
    begin
      result := '';
      Exit;
    end;
    if StdinKey = #4{\C-d} then
    begin
      term_p := True;
      SetLength(StdinBuf, Length(StdinBuf)-1);
      Break;
    end;
    Application.ProcessMessages;
  until StdinKey = #13;
  result := StdinBuf;
  if not term_p then result[Length(StdinBuf)] := #10;
  StdinBuf := '';
  StdinKey := #0;
end;

function getc: Char;
begin
  FormConsole.Show;
  while StdinKey = #0 do
  begin
    if not PhiAlive then
    begin
      result := #0;
      Exit;
    end;
    Application.ProcessMessages;
  end;
  result := StdinKey;
  StdinBuf := '';
  StdinKey := #0;
end;

procedure TFormConsole.btnClearClick(Sender: TObject);
begin
  Memo1.Clear;
end;

procedure TFormConsole.btnGCClick(Sender: TObject);
begin
  rb_gc;
end;

procedure TFormConsole.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  if FormBrowser.Visible then
    Action := caMinimize
  else
  begin
    Action := caNone;
    FormBrowser.Show;
  end;
end;

procedure TFormConsole.Memo1KeyPress(Sender: TObject; var Key: Char);
begin
  LblKey.Caption := IntToHex(Integer(Key), 2);
  StdinKey := Key;
  StdinBuf := StdinBuf + StdinKey;
end;

end.
