unit Browser;

interface

uses
  Types,
  SysUtils, Classes, QGraphics, QControls, QForms, QDialogs, QStdCtrls,
  QExtCtrls, QComCtrls, QMenus;

type
  TFormBrowser = class(TForm)
    StatusBar: TStatusBar;
    Memo1: TMemo;
    OpenDialog: TOpenDialog;
    Panel1: TPanel;
    EditPath: TEdit;
    btnExec: TButton;
    btnOpen: TButton;
    procedure FormCreate(Sender: TObject);
    procedure btnExecClick(Sender: TObject);
    procedure btnOpenClick(Sender: TObject);
    procedure Memo1Change(Sender: TObject);
    procedure Memo1Enter(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    FScriptDir: string;
    procedure doExec(Sender: TObject);
  public
    procedure JumpError;
    procedure LoadScript;
    procedure ThreadDone(Sender: TObject);
  end;

var
  FormBrowser: TFormBrowser;
  InExecCustom: Boolean = False;

implementation

uses
  Rubies,
{$IFDEF PHIEMBED}
  PhiMainUnit,
{$ELSE}
  PhiExternal,
{$ENDIF}
  Console, uStrUtils, Resource,
  uHandle, uError;

{$R *.xfm}

var
  age: Integer;

procedure ShowInfoFmt(const Msg: string; Params: array of const);
begin
  if not InExecCustom then
    ShowMessageFmt(Msg, Params);
end;

procedure init;
begin
  PhiExport('Apollo');
end;

procedure TFormBrowser.FormCreate(Sender: TObject);
{$IFDEF WIN32}
var
  argc: Integer;
  argv: Pointer;
{$ENDIF}
begin
{$IFDEF WIN32}
  argc := 0;
  argv := nil;
  NTInitialize(@argc, @argv);
{$ENDIF}
  ruby_init;
  ruby_init_loadpath;
  PhiSetStdoutProc(Stdout);
  PhiSetGetsFunc(gets);
  PhiSetGetcFunc(getc);
  PhiSetInitProc(init);
end;

procedure TFormBrowser.ThreadDone(Sender: TObject);
begin
  if Application.Terminated then exit;
  StatusBar.SimpleText := sReady;
  btnExec.Caption := sExecute;
end;

procedure ProcessOptions(Line: string);
var
  argc, i: Integer;
  S: string;
begin
  argc := ParamCount1(PChar(Line));
  for i := 0 to argc-1 do
  begin
    S := ParamStr1(PChar(Line), i+1);
    if S[1] = '-' then
    begin
      if Length(S) = 1 then Continue;
      case S[2] of
      'K': if Length(S) >= 3 then rb_set_kcode(@S[3]);
      end;
    end;
  end;
end;

procedure CommentOptions(Lines: TStrings);
const
  EXC = '#!';
  PROGNAME = 'ruby';
var
  S: string;
  n: Integer;
begin
  if Lines.Count = 0 then Exit;
  S := Lines[0];
  if Pos(EXC, S) = 0 then Exit;
  n := Pos(PROGNAME, S);
  if n = 0 then Exit;
  S := Copy(S, n, Length(S));
  if Length(S) = Length(PROGNAME) then Exit;
  case S[Length(PROGNAME)+1] of
  #9, ' ':
    ProcessOptions(S);
  end;
end;

procedure TFormBrowser.LoadScript;
var
  script: string;
  str: string;
begin
  script := EditPath.Text;
  try
    str := ParamStr1(PChar(script),0);
    try
      if FScriptDir <> '' then ChDir(FScriptDir);
      Memo1.Lines.LoadFromFile(str);
      CommentOptions(Memo1.Lines);

      age := FileAge(str);

      EditPath.Text := ExtractFileName(str);
      FScriptDir := ExtractFileDir(ExpandFileName(str));
      ChDir(FScriptDir);
    except
      ShowInfoFmt(fmt_cannot_read, [str]);
    end;

    if PhiAlive then
      btnExec.Caption := sTerminate
    else
      btnExec.Caption := sExecute;
  except
    on E: Exception do
      StatusBar.SimpleText := Format('%s(code %d)', [E.Message, E.HelpContext]);
  end;
end;

procedure TFormBrowser.btnOpenClick(Sender: TObject);
begin
  if OpenDialog.Execute then
  begin
    EditPath.Text := OpenDialog.FileName;
    if Pos(' ', EditPath.Text) <> 0 then
      EditPath.Text := '"' + EditPath.Text + '"';
    LoadScript;
  end;
  PhiHandle.NotifyOnClick(Sender);
end;

procedure TFormBrowser.JumpError;
var
  SkipChars, Col, Lineno: Integer;
  WStr: WideString;
begin
  try
    EditPath.Text := PhiErrorFile;
    LoadScript;
    Lineno := PhiErrorLine-1;
    SkipChars := 0;
    for Col := 0 to Lineno-1 do
    begin
      WStr := Memo1.Lines[Col];
      Inc(SkipChars, Length(WStr)+1
{$IFDEF WIN32}
  +1
{$ENDIF}
      );
    end;
    WStr := Memo1.Lines[Lineno];
    Memo1.SetFocus;
    Memo1.SelStart := SkipChars;
    Memo1.SelLength := Length(WStr);
  except
    on E: Exception do;
  end;
end;

procedure TFormBrowser.doExec(Sender: TObject);
var
  script: string;
  argc, i: Integer;
  str: string;
  args: array of string;
  argv: array of PChar;
begin
  argv := nil;

  chdir(FScriptDir);
  script := StringReplace(EditPath.Text, '\', '/', [rfReplaceAll]);

  argc := ParamCount1(PChar(script));
  SetLength(args, argc);
  SetLength(argv, argc);
  for i := 0 to argc-1 do
  begin
    args[i] := ParamStr1(PChar(script), i+1);
    argv[i] := PChar(args[i]);
  end;
  ruby_set_argv(argc, argv);

  str := ParamStr1(PChar(script),0);
  btnExec.Caption := sTerminate;
  StatusBar.SimpleText := sRunning;
  PhiLoadProtect(PChar(str), ThreadDone);
  if PhiErrorLine = -1 then
  else
    JumpError;
  FormConsole.Show;
end;

procedure TFormBrowser.btnExecClick(Sender: TObject);
var
  script: string;
  str: string;
begin
  if Memo1.Modified then
  begin
    script := StringReplace(EditPath.Text, '/', '\', [rfReplaceAll]);
    str := ParamStr1(PChar(script),0);
    try
      Memo1.Lines.SaveToFile(str);
      CommentOptions(Memo1.Lines);
    except
      ShowInfoFmt(fmt_cannot_save, [str]);
    end;
    Memo1.Modified := False;
    age := FileAge(str);
    if PhiAlive then
      btnExec.Caption := sTerminate
    else
      btnExec.Caption := sExecute;
  end
  else
  if PhiAlive then
    PhiTerminate
  else
  begin
    doExec(Sender);
  end;
end;

procedure TFormBrowser.Memo1Change(Sender: TObject);
begin
  btnExec.Caption := sSave;
end;

procedure TFormBrowser.Memo1Enter(Sender: TObject);
var
  script: string;
  str: string;
  cur: Integer;
begin
  if InExecCustom then Exit;
  script := EditPath.Text;
  str := ParamStr1(PChar(script),0);
  cur := FileAge(str);
  if age < cur then
    if MessageDlg(Format(fmt_modified, [str]),
      mtConfirmation, [mbYes, mbNo], 0) = mrYes then
      LoadScript
    else
    begin
      Memo1.Modified := True;
      btnExec.Caption := sSave;
    end;
end;

procedure TFormBrowser.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  PhiTerminate;
end;

end.
