program Apollo;

uses
  SysUtils,
  Classes,
  QForms,
  Rubies,
{$IFDEF PHIEMBED}
  PhiMainUnit, uError,
  uBitBtn, uDialogs, uIni, uRDB,
{$ELSE}
  PhiExternal,
{$ENDIF}
  Console in 'Console.pas' {FormConsole},
  Browser in 'Browser.pas' {FormBrowser},
  Resource;

{$R *.res}

var
  i: Integer;
  S: string;
  script, params: string;
begin
  Application.Initialize;
  Application.Title := 'Apollo';
  Application.CreateForm(TFormBrowser, FormBrowser);
  Application.CreateForm(TFormConsole, FormConsole);
  Init_phi;
  Init_bitbtn;
  Init_dialogs;
  Init_ini;
  Init_rdb;
  for i := 1 to ParamCount do
  begin
    S := ParamStr(i);
    if S[1] = '-' then
    begin
      if Length(S) = 1 then Continue;
      case S[2] of
      'K': if Length(S) >= 3 then rb_set_kcode(@S[3]);
      end;
    end
    else
      if params = '' then
      begin
        script := S;
        params := S;
      end else
        params := params +' '+ S;
  end;
  if params = '' then
    params := FormBrowser.EditPath.Text
  else
    FormBrowser.EditPath.Text := params
  ;
  PhiLoadProtect('custom.rb', nil);
  FormBrowser.LoadScript;
  PhiTerminate;
  Application.Run;
end.
