unit uRDB;

interface

uses
  Rubies, RDBHandle, DB,
  uFieldDef,
  uIndexDef,
  uField,
  uParam,
  uDataSource,
  uDataSet,
  uTable,
  uQuery,
  uStoredProc,
  uDatabase,
  uColumn,
  uDBGrid,
  uDBNavigator,
  uDBEdit,
  uDBMemo;

const
  RDBDLL = 'rdb.dll';

var
  mRDB,
  ap_eDatabaseError: Tvalue;
  Handle: TRDBHandle;

procedure Init_rdb;

implementation

uses
{$IFDEF PHIEMBED}
  PhiMainUnit, uHandle
{$ELSE}
  PhiExternal
{$ENDIF}
  ;

function RDBHandle: TRDBHandle;
begin
  result := Handle;
end;

procedure Init_rdb;
begin
  Handle := TRDBHandle.Create;
  PhiExtentList.Add(Handle);

  mRDB := rb_define_module('RDB');

  ap_eDatabaseError := rb_define_class_under(mRDB, 'DatabaseError', ap_eStandardError);

  Init_FieldDef;
  Init_IndexDef;
  Init_Param;
  Init_Field;
  Init_DataSource;
  Init_DataSet;
  Init_Table;
  Init_Query;
  Init_StoredProc;
  Init_Database;
  Init_Column;
  Init_DBGrid;
  Init_DBNavigator;
  Init_DBEdit;
  Init_DBMemo;
end;

exports
  RDBHandle,
  Init_rdb;

end.
