unit uQuery;

interface

uses Rubies;

var
  cQuery: Tvalue;

procedure Init_Query;

implementation

uses SysUtils, SqlExpr,
{$IFDEF PHIEMBED}
  PhiMainUnit, uHandle, uAlloc, uStrings, uComponent,
{$ELSE}
  PhiExternal,
{$ENDIF}
  uRDB, uDataSet, uParam;

function Query_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TSQLQuery;
begin
  real := TSQLQuery.Create(nil);
  result := DataSet_alloc1(This, real);
  DataSet_setup(result, real);

  rb_obj_call_init(result, argc, argv);
end;

function Query_execute(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TSQLQuery;
  args: array of Tvalue;
begin
  real := ap_data_get_struct(This);

  if argc > 0 then
  begin
    SetLength(args, argc);
    args := argv;
    real.Close;
    real.SQL.Text := STR2CSTR(args[0]);
  end;
  try
    real.ExecSQL;
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
  result := Qnil;
end;

function Query_open(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TSQLQuery;
  args: array of Tvalue;
begin
  real := ap_data_get_struct(This);
  if argc > 0 then
  begin
    SetLength(args, argc);
    args := argv;
    real.Close;
    real.SQL.Text := STR2CSTR(args[0]);
  end;
//  try
    real.Open;
//  except
//    on E: Exception do
//      ap_raise(ap_eDatabaseError, E.message);
//  end;
  result := This;
end;

function Query_get_sql(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLQuery;
begin
  real := ap_data_get_struct(This);
  result := TmpAlloc(ap_cStrings, real.SQL);
end;

function Query_get_params(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLQuery;
begin
  real := ap_data_get_struct(This);
  result := TmpAlloc(cParams, real.Params);
end;

procedure Init_Query;
begin
  cQuery := DefineCompoClass(mRDB, TSQLQuery, cDataSet, nil);
  DefineSingletonMethod(cQuery, 'new', Query_new);
  DefineMethod(cQuery, 'execute', Query_execute);
  rb_define_method(cQuery, 'open', @Query_open, -1);
  DefineAttrGet(cQuery, 'sql', Query_get_sql);
  DefineAttrGet(cQuery, 'params', Query_get_params);
end;

end.
