unit uIndexDef;

interface

uses Rubies, DB;

var
  cIndexDef, cIndexDefs: Tvalue;

function ap_cIndexDef: Tvalue;
function IndexDef_alloc(This: Tvalue; real: TIndexDef): Tvalue;
function IndexDefs_alloc(This: Tvalue; real: TIndexDefs): Tvalue;
procedure Init_IndexDef;

implementation

uses
  SysUtils,
{$IFDEF PHIEMBED}
  PhiMainUnit, uHandle, uAlloc, uProp, uConv,
{$ELSE}
  PhiExternal,
{$ENDIF}
  uRDB;

function ap_cIndexDef: Tvalue;
begin
  result := cIndexDef;
end;

function IndexDef_alloc(This: Tvalue; real: TIndexDef): Tvalue;
begin
  result := TmpAlloc(This, real);
end;

function IndexDefs_alloc(This: Tvalue; real: TIndexDefs): Tvalue;
begin
  result := TmpAlloc(This, real);
end;

function IndexDefs_aref(This, index: Tvalue): Tvalue; cdecl;
var
  real: TIndexDefs;
  n: Integer;
begin
  real := ap_data_get_struct(This);
  n := FIX2INT(index);
  if (n < 0) or (real.Count <= n) then
    ap_raise(ap_eIndexError, sOut_of_range);

  result := IndexDef_alloc(cIndexDef, real[n]);
end;

function IndexDefs_get_count(This: Tvalue): Tvalue; cdecl;
var
  real: TIndexDefs;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.Count);
end;

function ap_ary_to_TIndexOptions(ary: Tvalue): TIndexOptions;
var
  len: Integer;
  ptr: Pvalue;
  opts: TIndexOptions;
  n: Integer;
begin
  Check_Type(ary, T_ARRAY);
  len := ap_ary_len(ary);
  ptr := ap_ary_ptr(ary);
  opts := [];
  while len > 0 do
  begin
    n := FIX2INT(ptr^);
    if (n < Ord(Low(TIndexOption))) or (Ord(High(TIndexOption)) < n) then
      ap_raise(ap_eIndexError, sOut_of_range);
    Include(opts, TIndexOption(n));
    Dec(len);
    Inc(ptr);
  end;
  result := opts;
end;

function IndexDefs_add(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  args: array of Tvalue;
  real: TIndexDefs;
  IndexDef: TIndexDef;
begin
  SetLength(args, argc);
  args := argv;

  real := ap_data_get_struct(This);
  IndexDef := real.AddIndexDef;
  if argc > 0 then IndexDef.Name := STR2CSTR(args[0]);
  if argc > 1 then IndexDef.Fields := STR2CSTR(args[1]);
  if argc > 2 then IndexDef.Options := ap_ary_to_TIndexOptions(args[2]);
  result := IndexDef_alloc(cIndexDef, IndexDef);
end;

function IndexDefs_clear(This: Tvalue): Tvalue; cdecl;
var
  real: TIndexDefs;
begin
  real := ap_data_get_struct(This);
  real.Clear;
  result := Qnil;
end;

function IndexDefs_update(This: Tvalue): Tvalue; cdecl;
var
  real: TIndexDefs;
begin
  real := ap_data_get_struct(This);
  real.update;
  result := This;
end;

function IndexDef_to_s(This: Tvalue): Tvalue; cdecl;
var
  real:TIndexDef;
begin
  real := ap_data_get_struct(This);
  result := ap_String(Format('#<%s: fields="%s">',
  	[dl_ClassName(This), real.fields]));
end;

procedure Init_IndexDef;
begin
  DefineConstSetType(mRDB, TypeInfo(TIndexOption));

  cIndexDef := rb_define_class_under(mRDB, 'IndexDef', ap_cObject);
  DefineProp(cIndexDef, TIndexDef);

  cIndexDefs := rb_define_class_under(mRDB, 'IndexDefs', ap_cObject);
  rb_define_method(cIndexDefs, '[]', @IndexDefs_aref, 1);
  DefineAttrGet(cIndexDefs, 'count', IndexDefs_get_count);
  DefineMethod(cIndexDefs, 'add', IndexDefs_add);
  rb_define_method(cIndexDefs, 'clear', @IndexDefs_clear, 0);
  rb_define_method(cIndexDefs, 'update', @IndexDefs_update, 0);
  rb_define_method(cIndexDef, 'to_s', @IndexDef_to_s, 0);
end;

end.
