unit uField;

interface

uses Rubies, DB;

var
  cBlobStream, cField, cFields: Tvalue;

function Field_alloc(This: Tvalue; real: TField): Tvalue;
procedure Init_Field;

procedure Field_ap_data_assign(field: TField; v: Tvalue);

implementation

uses
  SysUtils, Classes, QGraphics,
{$IFDEF PHIEMBED}
  PhiMainUnit, uHandle, uAlloc, uProp, uConv, uDateTime,
{$ELSE}
  PhiExternal,
{$ENDIF}
  uRDB, uDataSet;

function dl_Field(v: Tvalue): TField;
begin
  result := TField(ap_data_get_struct(v));
end;

function Field_alloc(This: Tvalue; real: TField): Tvalue;
begin
  result := TmpAlloc(This, real);
end;

function Field_assign(This, v: Tvalue): Tvalue; cdecl;
var
  source: TPersistent;
begin
  ap_data_get_object(v, TPersistent, source);
  dl_Field(This).Assign(source);
  result := Qnil;
end;

function Field_save(This, v: Tvalue): Tvalue; cdecl;
var
  real: TField;
  stream: TStream;
begin
  real := ap_data_get_struct(This);
  if real is TBlobField then
    case RTYPE(v) of
    T_STRING:
      TBlobField(real).SaveToFile(STR2CSTR(v));
    T_DATA:
      begin
        ap_data_get_object(v, TStream, stream);
        TBlobField(real).SaveToStream(stream);
      end;
    end;
  result := v;
end;

function Field_get_data_type(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_Fixnum(Ord(dl_Field(This).DataType));
end;

function Field_get_to_f(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_Float(dl_Field(This).AsFloat);
end;

function Field_get_to_i(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_Fixnum(dl_Field(This).AsInteger);
end;

function Field_get_to_s(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Field(This).AsString);
end;

function Field_inspect(This: Tvalue): Tvalue; cdecl;
var
  real: TField;
  klass: Tvalue;
begin
  real := ap_data_get_struct(This);

  result := rb_str_new2('#');
  rb_str_cat(result, '<', 1);

  klass := CLASS_OF(This);
  klass := rb_class_path(klass);
  rb_str_concat(result, klass);
  rb_str_cat(result, ':', 1);

  ap_str_cat(result, ' data_type=');
  ap_str_cat_int(result, Ord(real.DataType));
  try
    ap_str_cat(result, ' field_name=');
    rb_str_concat(result, ap_get_str_prop(real, 'FieldName', '"'));
    ap_str_cat(result, ' value=');
    ap_str_cat(result, real.AsString);
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;

  rb_str_cat(result, '>', 1);
end;

function Field_get_data_set(This: Tvalue): Tvalue; cdecl;
begin
  result := DataSetTmpAlloc(dl_Field(This).DataSet);
end;

function Fields_aref(This, p: Tvalue): Tvalue; cdecl;
var
  real: TFields;
  n: Integer;
begin
  real := ap_data_get_struct(This);
  n := FIX2INT(p);
  if (n < 0) or (real.Count <= n) then
    ap_raise(ap_eIndexError, sOut_of_range);
  result := Field_alloc(cField, real[n]);
end;

function Fields_get_count(This: Tvalue): Tvalue; cdecl;
var
  real: TFields;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.Count);
end;

function Field_get_date_time(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_DateTime(dl_Field(This).asDateTime);
end;

function Field_set_date_time(This,v: Tvalue): Tvalue; cdecl;
begin
  result := v;
  dl_Field(This).asDateTime := dl_DateTime(v);
end;

function Field_get_new_value(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_Variant(TField(ap_data_get_struct(This)).NewValue);
end;

function Field_get_old_value(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_Variant(TField(ap_data_get_struct(This)).OldValue);
end;

function Field_get_cur_value(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_Variant(TField(ap_data_get_struct(This)).CurValue);
end;

function Field_get_value(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_Variant(TField(ap_data_get_struct(This)).Value);
end;

procedure Field_ap_data_assign(field: TField; v: Tvalue);
begin
  case RTYPE(v) of
  T_STRING:     field.asString  := dl_String(v);
  T_FIXNUM:     field.asInteger := NUM2INT(v);
  T_BIGNUM:     field.asInteger := NUM2INT(v); //??
  T_FLOAT :     field.asFloat   := NUM2DBL(v);
  T_TRUE  :     field.asBoolean := True;
  T_FALSE :     field.asBoolean := False;
  T_DATA  :
    if ap_kind_of(v, ap_cDateTime) then
      field.asDateTime := dl_DateTime(v);
  else
    ap_raise(ap_eArgError, sWrong_arg_type);
  end;
end;

function Field_set_value(This,v: Tvalue): Tvalue; cdecl;
begin
  Field_ap_data_assign( dl_Field(This) , v );
  result := v;
end;

function Field_get_can_modify(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_bool(dl_Field(This).CanModify);
end;

// ᔽ̃bZ[W  $! ɓׂ?
function Field_get_constraint_error_message(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Field(This).ConstraintErrorMessage);
end;

function Field_get_data_size(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_Fixnum(dl_Field(This).DataSize);
end;

function Field_get_edit_mask(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Field(This).EditMask);
end;

function Field_set_edit_mask(This,v: Tvalue): Tvalue; cdecl;
begin
  result := v;
  dl_Field(This).EditMask := dl_String(v);
end;

function Field_get_has_constraints(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_bool(dl_Field(This).HasConstraints);
end;

function Field_get_field_no(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_Fixnum(dl_Field(This).FieldNo);
end;

function Field_get_is_index_field(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_bool(dl_Field(This).IsIndexField);
end;

function Field_get_size(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_Fixnum(dl_Field(This).Size);
end;

function Field_get_text(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_String(dl_Field(This).Text);
end;

procedure Init_Field;
begin
  DefineConstSetType(mRDB, TypeInfo(TBlobStreamMode));

  DefineConstSetType(mRDB, TypeInfo(TFieldType));
  DefineConstSetType(mRDB, TypeInfo(TFieldKind));

  cField := rb_define_class_under(mRDB, 'Field', ap_cObject);
  DefineProp(cField, TField);
  rb_define_method(cField, 'assign', @Field_assign, 1);
  rb_define_method(cField, 'save', @Field_save, 1); // vcl: save_to_file, save_to_stream
  DefineAttrGet(cField, 'data_type', Field_get_data_type);
  DefineAttrGet(cField, 'to_f', Field_get_to_f); // vcl: AsFloat
  DefineAttrGet(cField, 'to_i', Field_get_to_i); // vcl: AsInteger
  DefineAttrGet(cField, 'to_s', Field_get_to_s); // vcl: AsString
  rb_define_method(cField, 'inspect', @Field_inspect, 0);

  DefineAttrGet(cField, 'new_value', Field_get_new_value);
  DefineAttrGet(cField, 'old_value', Field_get_old_value);
  DefineAttrGet(cField, 'cur_value', Field_get_cur_value);
  DefineAttrGet(cField, 'data_set', Field_get_data_set);
  DefineAttrGet(cField, 'can_modify' , Field_get_can_modify);
  DefineAttrGet(cField, 'constraint_error_message' , Field_get_constraint_error_message);
  DefineAttrGet(cField, 'data_size' , Field_get_data_size);
  DefineAttrGet(cField, 'edit_mask' , Field_get_edit_mask);
  DefineAttrSet(cField, 'edit_mask' , Field_set_edit_mask);
  DefineAttrGet(cField, 'has_constraints' , Field_get_has_constraints);
  DefineAttrGet(cField, 'field_no' , Field_get_field_no);
  DefineAttrGet(cField, 'is_index_field' , Field_get_is_index_field);
  DefineAttrGet(cField, 'size' , Field_get_size);
  DefineAttrGet(cField, 'text' , Field_get_text);
//  DefineAttrGet(cField, 'valid_chars' , Field_get_valid_chars);
//  DefineAttrSet(cField, 'valid_chars' , Field_set_valid_chars);

  cFields := rb_define_class_under(mRDB, 'Fields', ap_cObject);
  rb_define_method(cFields, '[]', @Fields_aref, 1);
  DefineAttrGet(cFields, 'count', Fields_get_count);
  DefineAttrGet(cField, 'date_time' , Field_get_date_time);
  DefineAttrSet(cField, 'date_time' , Field_set_date_time);
  DefineAttrGet(cField, 'value', Field_get_value);
  DefineAttrSet(cField, 'value', Field_set_value);
end;

end.
