unit uDatabase;

interface

uses Rubies, SqlExpr, DBXpress;

var
  cDatabase: Tvalue;

function ap_cDatabase: Tvalue;
function Database_alloc(This: Tvalue; real: TSQLConnection): Tvalue;
procedure Init_Database;

implementation

uses
  SysUtils, DB,
{$IFDEF PHIEMBED}
  PhiMainUnit, uHandle, uAlloc, uStrings, uComponent,
{$ELSE}
  PhiExternal,
{$ENDIF}
  uRDB, uDataSet;

var
  TD: TTransactionDesc;

function ap_cDatabase: Tvalue;
begin
  result := cDatabase;
end;

procedure Database_free(real: TSQLConnection); cdecl;
begin
  if real.Connected then real.Close;
  CompoFree(real);
end;

// CompoAlloc modified
function Database_alloc1(This: Tvalue; real: TSQLConnection): Tvalue;
begin
  if real = nil then begin result := Qnil; exit; end;
  PhiObjectList.Add(real);
  result := rb_data_object_alloc(This, real, nil, @Database_free);
  rb_iv_set(result, '@events', rb_hash_new);
  real.tag := result;
end;

function Database_alloc(This: Tvalue; real: TSQLConnection): Tvalue;
begin
  result := TmpAlloc(This, real);
end;

function Database_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
  args: array of Tvalue;
begin
  real := TSQLConnection.Create(nil);
  if argc > 0 then
  begin
    SetLength(args, argc);
    args := argv;
    try
      real.ConnectionName := STR2CSTR(args[0]);
      if argc > 1 then
      begin
        real.Params.add('user name='+STR2CSTR(args[1]));
        if argc > 2 then
        begin
          real.Params.add('password='+STR2CSTR(args[2]));
          real.LoginPrompt := false;
        end;
      end;
      real.Open;
    except
      on E: Exception do
        ap_raise(ap_eDatabaseError, E.message);
    end;
  end;
  result := Database_alloc1(This, real);
  rb_obj_call_init(result, argc, argv);
end;

function Database_execute(This, sql, v: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
  Params: TParams;
begin
  result := Qnil;
  real := ap_data_get_struct(This);
  try
    ap_data_get_object(v, TParams, Params);
    result := INT2FIX(real.Execute(STR2CSTR(sql), Params));
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
end;

function Database_close(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
begin
  real := ap_data_get_struct(This);
  real.Close;
  result := Qnil;
end;

function Database_close_datasets(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
begin
  real := ap_data_get_struct(This);
  try
    real.CloseDatasets;
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
  result := This;
end;

function Database_commit(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
begin
  real := ap_data_get_struct(This);
  try
    real.Commit(TD);
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
  result := This;
end;

function Database_rollback(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
begin
  real := ap_data_get_struct(This);
  try
    real.Rollback(TD);
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
  result := This;
end;

function Database_start_transaction(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
begin
  real := ap_data_get_struct(This);
  try
    real.StartTransaction(TD);
  except on E: Exception do
    ap_raise(ap_eDatabaseError, E.message);
  end;
  result := This;
end;

function Database_get_params(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
begin
  real := ap_data_get_struct(This);
  result := TmpAlloc(ap_cStrings, real.params);
end;

function Database_get_data_sets(This: Tvalue): Tvalue; cdecl;
var
  real: TSQLConnection;
  i:integer;
begin
  result := rb_ary_new;
  real := ap_data_get_struct(This);
  try
    for i := 0 to real.DataSetCount-1 do
    begin
      rb_ary_push(result, DataSetTmpAlloc(real.DataSets[i]));
    end;
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
end;

procedure Init_Database;
begin
  TD.TransactionID := 1;
  TD.IsolationLevel := xilREADCOMMITTED;

  cDatabase := DefineCompoClass(mRDB, TSQLConnection, ap_cObject, nil);
  DefineSingletonMethod(cDatabase, 'new', Database_new);
  rb_define_method(cDatabase, 'execute', @Database_execute, 1);
  rb_define_method(cDatabase, 'close', @Database_close, 0);
  rb_define_method(cDatabase, 'close_datasets', @Database_close_datasets, 0);
  rb_define_method(cDatabase, 'commit', @Database_commit, 0);
  rb_define_method(cDatabase, 'rollback', @Database_rollback, 0);
  rb_define_method(cDatabase, 'start_transaction', @Database_start_transaction, 0);

  DefineAttrGet(cDatabase, 'params', Database_get_params);
  DefineAttrGet(cDatabase, 'data_sets', Database_get_data_sets);
end;

exports
  ap_cDatabase,
  Database_alloc;

end.
