unit uDataSource;

interface

uses Rubies;

var
  cDataSource: Tvalue;

procedure Init_DataSource;

implementation

uses
  DB,
{$IFDEF PHIEMBED}
  PhiMainUnit, uHandle, uAlloc, uProp, uComponent,
{$ELSE}
  PhiExternal,
{$ENDIF}
  uRDB;

function DataSource_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TDataSource;
  args: array of Tvalue;
  DataSet: TDataSet;
begin
  real := TDataSource.Create(nil);
  result := CompoAlloc(This, real);
  if argc > 0 then
  begin
    SetLength(args, argc);
    args := argv;
    ap_data_get_object(args[0], TDataSet, DataSet);
    real.DataSet := DataSet;
  end;
  AssignPropMethod(real, [handle]);
  rb_obj_call_init(result, argc, argv);
end;

function DataSource_set_data_set(This, v: Tvalue): Tvalue; cdecl;
var
  real: TDataSource;
  DataSet: TDataSet;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TDataSet, DataSet);
  real.DataSet := DataSet;
  result := v;
end;

function DataSource_get_data_set(This: Tvalue): Tvalue; cdecl;
var
  real: TDataSource;
begin
  real := ap_data_get_struct(This);
  result := real.DataSet.tag;
end;

procedure Init_DataSource;
begin
  cDataSource := DefineCompoClass(mRDB, TDataSource, ap_cObject, nil);
  DefineSingletonMethod(cDataSource, 'new', DataSource_new);
  DefineAttrSet(cDataSource, 'data_set', DataSource_set_data_set);
  DefineAttrGet(cDataSource, 'data_set', DataSource_get_data_set);
end;

end.
