unit uDataSet;

interface

uses Rubies, DB, DBClient, SqlExpr;

var
  cDataSet: Tvalue;

function DataSetTmpAlloc(Dataset: TDataSet): Tvalue;
procedure DataSet_setup(This: Tvalue; real: TDataSet);
function DataSet_alloc1(This: Tvalue; real: TDataSet): Tvalue;
procedure Init_DataSet;

implementation

uses
  SysUtils, Classes, QGraphics,
{$IFDEF PHIEMBED}
  PhiMainUnit, uHandle, uAlloc, uProp, uComponent,
{$ELSE}
  PhiExternal,
{$ENDIF}
  Variants,
  RDBHandle, uRDB, uTable, uQuery, uStoredProc, uField;

function dl_SQLDataSet(This: Tvalue): TSQLDataSet;
begin
  result := ap_data_get_struct(This);
end;

function dl_DataSet(This: Tvalue): TDataSet;
begin
  result := ap_data_get_struct(This);
end;

function DataSetTmpAlloc(Dataset: TDataSet): Tvalue;
var
  klass: Tvalue;
begin
  if DataSet is TSQLTable then klass := cTable
  else if DataSet is TSQLQuery then klass := cQuery
  else if DataSet is TSQLStoredProc then klass := cStoredProc
  else klass := Qnil { error };
  result := TmpAlloc(klass, DataSet);
end;

procedure DataSet_setup(This: Tvalue; real: TDataSet);
begin
  AssignPropMethod(real, [handle]);
end;

procedure DataSet_free(real: TDataSet); cdecl;
begin
  if real.Active then real.Close;
  CompoFree(real);
end;

// CompoAlloc modified
function DataSet_alloc1(This: Tvalue; real: TDataSet): Tvalue;
begin
  if real = nil then begin result := Qnil; exit; end;
  PhiObjectList.Add(real);
  result := rb_data_object_alloc(This, real, nil, @DataSet_free);
  rb_iv_set(result, '@events', rb_hash_new);
  real.tag := result;
end;

function DataSet_aref(This, p: Tvalue): Tvalue; cdecl;
var
  n: Integer;
  real: TDataSet;
  field: TField;
begin
  real := dl_DataSet(This);
  field := nil;

  case RTYPE(p) of
  T_STRING:
      field := real.FindField(STR2CSTR(p));
  T_FIXNUM:
    begin
      n := FIX2INT(p);
      if (n < 0) or (real.Fields.Count <= n) then
        ap_raise(ap_eIndexError, sOut_of_range);
      field := real.Fields[n];
    end;
  else
    ap_raise(ap_eArgError, sWrong_arg_type);
  end;

  if field = nil then
    result := Qnil
  else
    result := Field_alloc(cField, field)
  ;
end;

function DataSet_aset(This, p, v: Tvalue): Tvalue; cdecl;
var
  n: Integer;
  real: TDataSet;
  field: TField;
begin
  real := dl_DataSet(This);
  field := nil;

  case RTYPE(p) of
  T_STRING:
      field := real.FindField(STR2CSTR(p));
  T_FIXNUM:
    begin
      n := FIX2INT(p);
      if (n < 0) or (real.Fields.Count <= n) then
        ap_raise(ap_eIndexError, sOut_of_range);
      field := real.Fields[n];
    end;
  else
    ap_raise(ap_eArgError, sWrong_arg_type);
  end;

  if field = nil then
    result := Qnil
  else
  begin
    result := Field_alloc(cField, field);
    Field_ap_data_assign(field , v);
  end;
end;

function DataSet_get_fields(This: Tvalue): Tvalue; cdecl;
begin
  result := TmpAlloc(cFields, dl_DataSet(This).Fields);
end;

function DataSet_get_state(This: Tvalue): Tvalue; cdecl;
begin
  result := INT2FIX(Ord(dl_DataSet(This).State));
end;

function DataSet_close(This: Tvalue): Tvalue; cdecl;
begin
  result := This;
  dl_DataSet(This).Close;
end;

function DataSet_close1(This: Tvalue): Tvalue; cdecl;
begin
  result := DataSet_close(This);
end;

function DataSet_open(This: Tvalue): Tvalue; cdecl;
begin
  dl_DataSet(This).Open;
  if rb_block_given_p <> 0 then
    result := rb_ensure(@rb_yield, This, @DataSet_close1, This)
  else
    result := This
  ;
end;

function DataSet_edit(This: Tvalue): Tvalue; cdecl;
begin
  dl_DataSet(This).Edit;
  result := This;
end;

function DataSet_post(This: Tvalue): Tvalue; cdecl;
begin
  dl_DataSet(This).Post;
  result := This;
end;

function DataSet_append(This: Tvalue): Tvalue; cdecl;
begin
  dl_DataSet(This).Append;
  result := This;
end;

function DataSet_insert(This: Tvalue): Tvalue; cdecl;
begin
  dl_DataSet(This).Insert;
  result := This;
end;

function DataSet_delete(This: Tvalue): Tvalue; cdecl;
begin
  dl_DataSet(This).Delete;
  result := This;
end;

function DataSet_first(This: Tvalue): Tvalue; cdecl;
begin
  dl_DataSet(This).First;
  result := This;
end;

function DataSet_last(This: Tvalue): Tvalue; cdecl;
begin
  dl_DataSet(This).Last;
  result := This;
end;

function DataSet_next(This: Tvalue): Tvalue; cdecl;
begin
  dl_DataSet(This).Next;
  result := This;
end;

function DataSet_prior(This: Tvalue): Tvalue; cdecl;
begin
  dl_DataSet(This).Prior;
  result := This;
end;

function DataSet_move_by(This, v: Tvalue): Tvalue; cdecl;
begin
  result := INT2FIX(dl_DataSet(This).MoveBy(FIX2INT(v)));
end;

function DataSet_locate(This, fields, values, options: Tvalue): Tvalue; cdecl;
var
  v: Tvalue;
  S: string;
  i: Integer;
  n: Integer;
  len: Integer;
  ptr: Pvalue;
  A: Variant;
  field: TField;
  ary: Tvalue;
  Opts: TLocateOptions;
  real: TDataSet;
begin
  real := dl_DataSet(This);
  S := STR2CSTR(fields);
  if RTYPE(values) = T_ARRAY then
  begin
    len := ap_ary_len(values);
    ptr := ap_ary_ptr(values);
    A := VarArrayCreate([0, len-1], varVariant);
    for i := 0 to len-1 do
    begin
      v := ptr^;
      case RTYPE(v) of
      T_STRING: A[i] := string(STR2CSTR(v));
      T_FIXNUM: A[i] := FIX2INT(v);
      T_BIGNUM: A[i] := NUM2INT(v);
      T_FLOAT : A[i] := NUM2DBL(v);
      T_TRUE  : A[i] := True;
      T_FALSE : A[i] := False;
      T_DATA  :
        begin
          ap_data_get_object(v, TField, field);
          A[i] := field.AsString;
        end;
      else
        ap_raise(ap_eArgError, sWrong_arg_type);
      end;
      Inc(ptr);
    end;
  end else begin
      v := values;
      case RTYPE(v) of
      T_STRING: A := string(STR2CSTR(v));
      T_FIXNUM: A := FIX2INT(v);
      T_BIGNUM: A := NUM2INT(v);
      T_FLOAT : A := NUM2DBL(v);
      T_TRUE  : A := True;
      T_FALSE : A := False;
      T_DATA  :
        begin
          ap_data_get_object(v, TField, field);
          A := field.AsString;
        end;
      else
        ap_raise(ap_eArgError, sWrong_arg_type);
      end;
  end;
    ary := options;
    Check_Type(ary, T_ARRAY);
    len := ap_ary_len(ary);
    ptr := ap_ary_ptr(ary);
    Opts := [];
    while len > 0 do
    begin
      n := FIX2INT(ptr^);
      try
        Include(Opts, TLocateOption(n));
      except
        ap_raise(ap_eIndexError, sOut_of_range);
      end;
      Dec(len);
      Inc(ptr);
    end;
  result := Qnil;
  try
    result := ap_bool(real.Locate(S, A, Opts));
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
end;

function DataSet_get_bof(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_bool(dl_DataSet(This).Bof);
end;

function DataSet_get_eof(This: Tvalue): Tvalue; cdecl;
begin
  result := ap_bool(dl_DataSet(This).Eof);
end;

function DataSet_update_status(This: Tvalue): Tvalue; cdecl;
begin
  result := INT2FIX(ord(dl_SQLDataSet(This).UpdateStatus));
end;

procedure Init_DataSet;
begin
  DefineConstSetType(mRDB, TypeInfo(TDataSetState));
  DefineConstSetType(mRDB, TypeInfo(TDataAction));

  cDataSet := DefineCompoClass(mRDB, TDataSet, ap_cObject, nil);
  rb_undef_method(CLASS_OF(cDataSet), 'new');
  DefineAttrGet(cDataSet, 'fields', DataSet_get_fields);
  DefineAttrGet(cDataSet, 'state', DataSet_get_state);
  rb_define_method(cDataSet, 'open', @DataSet_open, 0);
  rb_define_method(cDataSet, 'close', @DataSet_close, 0);
  rb_define_method(cDataSet, 'edit', @DataSet_edit, 0);
  rb_define_method(cDataSet, 'post', @DataSet_post, 0);
  rb_define_method(cDataSet, 'append', @DataSet_append, 0);
  rb_define_method(cDataSet, 'insert', @DataSet_insert, 0);
  rb_define_method(cDataSet, 'delete', @DataSet_delete, 0);

  // vcl: FieldByName, FindField
  rb_define_method(cDataSet, '[]', @DataSet_aref, 1);
  rb_define_method(cDataSet, '[]=', @DataSet_aset, 2);

  rb_define_method(cDataSet, 'first', @DataSet_first, 0);
  rb_define_method(cDataSet, 'last', @DataSet_last, 0);
  rb_define_method(cDataSet, 'next', @DataSet_next, 0);
  rb_define_method(cDataSet, 'prior', @DataSet_prior, 0);
  rb_define_method(cDataSet, 'move_by', @DataSet_move_by, 1);
  rb_define_method(cDataSet, 'locate', @DataSet_locate, 3);
  DefineAttrGet(cDataSet, 'bof?', DataSet_get_bof);
  DefineAttrGet(cDataSet, 'eof?', DataSet_get_eof);

  DefineAttrMethod_retval(cDataSet, 'on_delete_error');
  DefineAttrMethod_retval(cDataSet, 'on_edit_error');
  DefineAttrMethod_retval(cDataSet, 'on_filter_record');
  DefineAttrMethod_retval(cDataSet, 'on_update_record');
  DefineAttrMethod_retval(cDataSet, 'on_post_error');
end;

end.
