unit uDBNavigator;

interface

uses Rubies;

var
  cDBNavigator: Tvalue;

procedure Init_DBNavigator;

implementation

uses
  DB, QDBCtrls,
{$IFDEF PHIEMBED}
  PhiMainUnit, uHandle, uProp, uAlloc,
  uSizeConstraints, uFont,
  uComponent, uControl,
{$ELSE}
  PhiExternal,
{$ENDIF}
  uRDB;

function DBNavigator_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TDBNavigator;
begin
  real := TDBNavigator.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);

  rb_obj_call_init(result, argc, argv);
end;

function DBNavigator_set_data_source(This, v: Tvalue): Tvalue; cdecl;
var
  real: TDBNavigator;
begin
  real := ap_data_get_struct(This);
  real.DataSource := TDataSource(ap_data_get_struct(v));
  result := v;
end;

procedure Init_DBNavigator;
begin
  cDBNavigator := DefineCompoClass(mRDB, TDBNavigator, ap_cWinControl, nil);
  DefineSingletonMethod(cDBNavigator, 'new', DBNavigator_new);
  DefineAttrSet(cDBNavigator, 'data_source', DBNavigator_set_data_source);
end;

end.
