unit uDBMemo;

interface

uses Rubies, DB, QDBCtrls;

var
  cDBMemo: Tvalue;

procedure DBMemo_setup(obj: Tvalue; real: TDBMemo);
procedure Init_DBMemo;

implementation

uses
{$IFDEF PHIEMBED}
  PhiMainUnit, uHandle, uProp, uAlloc,
  uSizeConstraints, uFont,
  uComponent, uMemo,
{$ELSE}
  PhiExternal,
{$ENDIF}
  uRDB, udataSource;

procedure DBMemo_setup(obj: Tvalue; real: TDBMemo);
begin
  rb_iv_set(obj, '@constraints', SizeConstraints_alloc(ap_cSizeConstraints, real.Constraints));
  rb_iv_set(obj, '@font', Font_alloc(ap_cFont, real.Font));
  AssignPropMethod(real, [PhiHandle]);
end;

function DBMemo_alloc(This: Tvalue; real: TDBMemo): Tvalue;
begin
  result := ChildAlloc(This, real);
  DBMemo_setup(result, real);
end;

function DBMemo_alloc_v(var AControl): Tvalue;
begin
  result := DBMemo_alloc(cDBMemo, TDBMemo(AControl));
end;

function DBMemo_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TDBMemo;
begin
  real := TDBMemo.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  DBMemo_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function DBMemo_set_data_source(This, v: Tvalue): Tvalue; cdecl;
var
  real: TDBMemo;
begin
  real := ap_data_get_struct(This);
  real.DataSource := TDataSource(ap_data_get_struct(v));
  result := v;
end;

function DBMemo_set_data_field(This, v: Tvalue): Tvalue; cdecl;
var
  real: TDBMemo;
begin
  real := ap_data_get_struct(This);
  real.DataField := STR2CSTR(v);
  result := v;
end;

procedure Init_DBMemo;
begin
  cDBMemo := DefineCompoClass(mRDB, TDBMemo, ap_cMemo, DBMemo_alloc_v);
  DefineSingletonMethod(cDBMemo, 'new', DBMemo_new);
  DefineAttrSet(cDBMemo, 'data_source', DBMemo_set_data_source);
  DefineAttrSet(cDBMemo, 'data_field', DBMemo_set_data_field);
end;

end.
