unit uDBGrid;

interface

uses Rubies, DB, QDBGrids;

var
  cDBGrid: Tvalue;

procedure DBGrid_setup(obj: Tvalue; real: TDBGrid);
function DBGrid_alloc(This: Tvalue; real: TDBGrid): Tvalue;
procedure Init_DBGrid;

implementation

uses
  SysUtils,
{$IFDEF PHIEMBED}
  PhiMainUnit, uHandle, uProp, uAlloc,
  uSizeConstraints, uCanvas, uFont,
  uComponent, uGrid,
{$ELSE}
  PhiExternal,
{$ENDIF}
  uRDB, uColumn, uField;

procedure DBGrid_setup(obj: Tvalue; real: TDBGrid);
begin
  rb_iv_set(obj, '@columns', Columns_alloc(cColumns, real.Columns));
  rb_iv_set(obj, '@canvas', Canvas_alloc(ap_cCanvas, real.Canvas));
  rb_iv_set(obj, '@font', Font_alloc(ap_cFont, real.Font));
  AssignPropMethod(real, [handle, PhiHandle]);
end;

function DBGrid_alloc(This: Tvalue; real: TDBGrid): Tvalue;
begin
  result := ChildAlloc(This, real);
  DBGrid_setup(result, real);
end;

function DBGrid_alloc_v(var AControl): Tvalue;
begin
  result := DBGrid_alloc(cDBGrid, TDBGrid(AControl))
end;

function DBGrid_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TDBGrid;
begin
  real := TDBGrid.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  DBGrid_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function DBGrid_set_data_source(This, v: Tvalue): Tvalue; cdecl;
var
  real: TDBGrid;
begin
  real := ap_data_get_struct(This);
  real.DataSource := TDataSource(ap_data_get_struct(v));
  result := v;
end;

function DBGrid_get_field_count(This: Tvalue): Tvalue; cdecl;
var
  real: TDBGrid;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.FieldCount);
end;

function DBGrid_get_fields(This: Tvalue): Tvalue; cdecl;
var
  real: TDBGrid;
  i:integer;
begin
  real := ap_data_get_struct(This);
  result := rb_ary_new;
  try
    for i := 0 to real.FieldCount-1 do
    begin
      rb_ary_push(result, Field_alloc(cField, real.Fields[i]));
    end;
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
end;

function DBGrid_get_selected_field(This: Tvalue): Tvalue; cdecl;
var
  real: TDBGrid;
begin
  result := Qnil;
  real := ap_data_get_struct(This);
  try
    result := Field_alloc(cField, real.SelectedField);
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
end;

procedure Init_DBGrid;
begin
  cDBGrid := DefineCompoClass(mRDB, TDBGrid, ap_cCustomGrid, DBGrid_alloc_v);
  DefineSingletonMethod(cDBGrid, 'new', DBGrid_new);
  DefineAttrSet(cDBGrid, 'data_source', DBGrid_set_data_source);
  DefineAttrGet(cDBGrid, 'field_count', DBGrid_get_field_count);
  DefineAttrGet(cDBGrid, 'fields', DBGrid_get_fields);
  DefineAttrGet(cDBGrid, 'selected_field', DBGrid_get_selected_field);
//  rb_define_attr(cDBGrid, 'columns', 1, 0);
  rb_define_attr(cDBGrid, 'canvas', 1, 0);
//  rb_define_attr(cDBGrid, 'font', 1, 0);
end;

end.
