unit uDBEdit;

interface

uses Rubies, QDBCtrls;

var
  cDBEdit: Tvalue;

procedure DBEdit_setup(obj: Tvalue; real: TDBEdit);
function DBEdit_alloc(This: Tvalue; real: TDBEdit): Tvalue;
procedure Init_DBEdit;

implementation

uses
  DB,
{$IFDEF PHIEMBED}
  PhiMainUnit, uHandle, uProp, uAlloc,
  uSizeConstraints, uFont,
  uComponent, uEdit,
{$ELSE}
  PhiExternal,
{$ENDIF}
  uRDB;

procedure DBEdit_setup(obj: Tvalue; real: TDBEdit);
begin
  rb_iv_set(obj, '@constraints', SizeConstraints_alloc(ap_cSizeConstraints, real.Constraints));
  rb_iv_set(obj, '@font', Font_alloc(ap_cFont, real.Font));
  AssignPropMethod(real, [PhiHandle]);
end;

function DBEdit_alloc(This: Tvalue; real: TDBEdit): Tvalue;
begin
  result := ChildAlloc(This, real);
  DBEdit_setup(result, real);
end;

function DBEdit_alloc_v(var AControl): Tvalue;
begin
  result := DBEdit_alloc(cDBEdit, TDBEdit(AControl));
end;

function DBEdit_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TDBEdit;
begin
  real := TDBEdit.Create(nil);
  result := CompoAlloc(This, real);
  CompoSetup(argc, argv, real);
  DBEdit_setup(result, real);
  rb_obj_call_init(result, argc, argv);
end;

function DBEdit_set_data_source(This, v: Tvalue): Tvalue; cdecl;
var
  real: TDBEdit;
begin
  real := ap_data_get_struct(This);
  real.DataSource := TDataSource(ap_data_get_struct(v));
  result := v;
end;

function DBEdit_set_data_field(This, v: Tvalue): Tvalue; cdecl;
var
  real: TDBEdit;
begin
  real := ap_data_get_struct(This);
  real.DataField := STR2CSTR(v);
  result := v;
end;

procedure Init_DBEdit;
begin
  cDBEdit := DefineCompoClass(mRDB, TDBEdit, ap_cEdit, DBEdit_alloc_v);
  DefineSingletonMethod(cDBEdit, 'new', DBEdit_new);
  DefineAttrSet(cDBEdit, 'data_source', DBEdit_set_data_source);
  DefineAttrSet(cDBEdit, 'data_field', DBEdit_set_data_field);
end;

end.
