unit uColumn;

interface

uses Rubies, QDBGrids;

var
  cColumn, cColumns: Tvalue;

function ap_cColumn: Tvalue;
procedure Column_setup(obj: Tvalue; real: TColumn);
function Column_alloc(This: Tvalue; real: TColumn): Tvalue;
function Columns_alloc(This: Tvalue; real: TDBGridColumns): Tvalue;
procedure Init_Column;

implementation

uses
{$IFDEF PHIEMBED}
  PhiMainUnit, uHandle, uProp, uAlloc,
  uFont,
{$ELSE}
  PhiExternal,
{$ENDIF}
  uRDB, uField;

function ap_cColumn: Tvalue;
begin
  result := cColumn;
end;

procedure Column_setup(obj: Tvalue; real: TColumn);
begin
  rb_iv_set(obj, '@field', Field_alloc(cField, real.Field));
  rb_iv_set(obj, '@font', Font_alloc(ap_cFont, real.Font));
end;

function Column_alloc(This: Tvalue; real: TColumn): Tvalue;
begin
  result := TmpAlloc(This, real);
  Column_setup(result, real);
end;

function Columns_alloc(This: Tvalue; real: TDBGridColumns): Tvalue;
begin
  result := TmpAlloc(This, real);
end;

function Columns_aref(This, index: Tvalue): Tvalue; cdecl;
var
  real: TDBGridColumns;
  n: Integer;
begin
  real := ap_data_get_struct(This);
  n := FIX2INT(index);
  if (n < 0) or (real.Count <= n) then
    ap_raise(ap_eIndexError, sOut_of_range);

  real := ap_data_get_struct(This);
  result := Column_alloc(cColumn, real[n]);
end;

function Columns_get_count(This: Tvalue): Tvalue; cdecl;
var
  real: TDBGridColumns;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.Count);
end;

procedure Init_Column;
begin
  cColumn := rb_define_class_under(mRDB, 'Column', ap_cObject);
  DefineProp(cColumn, TColumn);
  rb_define_attr(cColumn, 'field', 1, 0);
  rb_define_attr(cColumn, 'font', 1, 0);

  cColumns := rb_define_class_under(mRDB, 'Columns', ap_cObject);
  rb_define_method(cColumns, '[]', @Columns_aref, 1);
  DefineAttrGet(cColumns, 'count', Columns_get_count);
end;

end.
