unit uDialogs;

interface

uses Classes, Rubies,
{$IFDEF PHIEMBED}
  PhiMainUnit, uHandle, uAlloc, uProp, uPhi, uFont, uComponent,
{$ELSE}
  PhiExternal,
{$ENDIF}
  QDialogs;

var
  cDialog, cOpenDialog, cSaveDialog, cColorDialog, cFontDialog: Tvalue;

procedure Init_dialogs;

implementation

//  message_dlg(mesg, dlg_type=MT_CUSTOM, btns=[MB_OK], help_ctx=0, x=-1, y=-1) : Fixnum
function Phi_message_dlg(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  args: array of Tvalue;
  Mesg: string;
  num: Integer;
  DlgType: TMsgDlgType;
  ary: Tvalue;
  Btns: TMsgDlgButtons;
  HelpCtx: Longint;
  len: Integer;
  ptr: Pvalue;
  n: Integer;
  X, Y: Integer;
  ret: Word;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  SetLength(args, argc);
  args := argv;

  mesg := STR2CSTR(args[0]);

  DlgType := mtCustom;
  if argc > 1 then
  begin
    num := FIX2INT(args[1]);
    try
      DlgType := TMsgDlgType(num);
    except
      ap_raise(ap_eArgError, sOut_of_range);
    end;
  end;

  if argc > 2 then
  begin
    ary := args[2];
    Check_Type(ary, T_ARRAY);
    len := ap_ary_len(ary);
    ptr := ap_ary_ptr(ary);
    Btns := [];
    while len > 0 do
    begin
      n := FIX2INT(ptr^);
      try
        Include(Btns, TMsgDlgBtn(n));
      except
        ap_raise(ap_eIndexError, sOut_of_range);
      end;
      Dec(len);
      Inc(ptr);
    end;
  end
  else
    Btns := [mbOK]
  ;

  if argc > 3 then
    HelpCtx := INT2FIX(args[3])
  else
    HelpCtx := 0
  ;

  if argc > 4 then
    X := INT2FIX(args[4])
  else
    X := -1
  ;

  if argc > 5 then
    Y := INT2FIX(args[5])
  else
    Y := -1
  ;

  ret := MessageDlgPos(mesg, DlgType, Btns, HelpCtx, X, Y);
  result := INT2FIX(ret);
end;

function Phi_input_query(This, cap, prompt, v: Tvalue): Tvalue; cdecl;
var
  S: string;
begin
  S := STR2CSTR(v);
  result := ap_bool(InputQuery(STR2CSTR(cap), STR2CSTR(prompt), S));
  rb_str_resize(v, 0);
  ap_str_cat(v, S);
end;

function OpenDialog_new(This: Tvalue): Tvalue; cdecl;
var
  real: TOpenDialog;
begin
  real := TOpenDialog.Create(nil);
  result := CompoAlloc(This, real);
  AssignPropMethod(real, [PhiHandle]);
  rb_obj_call_init(result, 0, nil);
end;

function OpenDialog_execute(This: Tvalue): Tvalue; cdecl;
var
  real: TOpenDialog;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.Execute);
end;

function SaveDialog_new(This: Tvalue): Tvalue; cdecl;
var
  real: TSaveDialog;
begin
  real := TSaveDialog.Create(nil);
  result := CompoAlloc(This, real);
  AssignPropMethod(real, [PhiHandle]);
  rb_obj_call_init(result, 0, nil);
end;

function SaveDialog_execute(This: Tvalue): Tvalue; cdecl;
var
  real: TSaveDialog;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.Execute);
end;

function ColorDialog_new(This: Tvalue): Tvalue; cdecl;
var
  real: TColorDialog;
begin
  real := TColorDialog.Create(nil);
  result := CompoAlloc(This, real);
  AssignPropMethod(real, [PhiHandle]);
  rb_obj_call_init(result, 0, nil);
end;

function ColorDialog_execute(This: Tvalue): Tvalue; cdecl;
var
  real: TColorDialog;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.Execute);
end;

function FontDialog_new(This: Tvalue): Tvalue; cdecl;
var
  real: TFontDialog;
begin
  real := TFontDialog.Create(nil);
  result := CompoAlloc(This, real);
  rb_iv_set(result, '@font', Font_alloc(ap_cFont, real.Font));
  AssignPropMethod(real, [PhiHandle]);
  rb_obj_call_init(result, 0, nil);
end;

function FontDialog_execute(This: Tvalue): Tvalue; cdecl;
var
  real: TFontDialog;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.Execute);
end;

procedure Init_dialogs;
begin
  DefineConstSetType(ap_mPhi, TypeInfo(TMsgDlgBtn));
  DefineConstSetType(ap_mPhi, TypeInfo(TMsgDlgType));
//  DefineConstSetType(ap_mPhi, TypeInfo(TFontDialogOption));

  DefineModuleFunction(ap_mPhi, 'message_dlg', Phi_message_dlg);
  rb_define_module_function(ap_mPhi, 'input_query', @Phi_input_query, 3);

  cDialog := DefineCompoClass(ap_mPhi, TDialog, ap_cComponent, nil);

  cOpenDialog := DefineCompoClass(ap_mPhi, TOpenDialog, cDialog, nil);
  rb_define_singleton_method(cOpenDialog, 'new', @OpenDialog_new, 0);
  rb_define_method(cOpenDialog, 'execute', @OpenDialog_execute, 0);

  cSaveDialog := DefineCompoClass(ap_mPhi, TSaveDialog, cDialog, nil);
  rb_define_singleton_method(cSaveDialog, 'new', @SaveDialog_new, 0);
  rb_define_method(cSaveDialog, 'execute', @SaveDialog_execute, 0);

  cColorDialog := DefineCompoClass(ap_mPhi, TColorDialog, cDialog, nil);
  rb_define_singleton_method(cColorDialog, 'new', @ColorDialog_new, 0);
  rb_define_method(cColorDialog, 'execute', @ColorDialog_execute, 0);

  cFontDialog := DefineCompoClass(ap_mPhi, TFontDialog, cDialog, nil);
  rb_define_singleton_method(cFontDialog, 'new', @FontDialog_new, 0);
  rb_define_method(cFontDialog, 'execute', @FontDialog_execute, 0);
end;

exports
  Init_dialogs;

end.
