unit Rubies;

interface

uses SysUtils;

resourcestring
  sWrong_num_of_args = 'wrong # of arguments';
  sWrong_arg_type = 'wrong argument type';
  sToo_few_args = 'too few arguments';
  sOut_of_range = 'out of range';

{$I ruby_type.pas}

{$I ruby_interface.pas}
{$I ruby_funcfaces.pas}

procedure DefineSingletonMethod(klass: Tvalue; name: PChar; func1: TFunc1); stdcall;
procedure DefineMethod(klass: Tvalue; name: PChar; func1: TFunc1); stdcall;
procedure DefineAttrGet(klass: Tvalue; name: PChar; attr0: TAttr0); stdcall;
procedure DefineAttrSet(klass: Tvalue; name: PChar; attr1: TAttr1); stdcall;
procedure DefineModuleFunction(module: Tvalue; name: PChar; func1: TFunc1); stdcall;
procedure DefineModuleAttrGet(module: Tvalue; name: PChar; attr0: TAttr0); stdcall;
procedure DefineModuleAttrSet(module: Tvalue; name: PChar; attr1: TAttr1); stdcall;
procedure ap_define_const(klass: Tvalue; const name: String; v: Tvalue);
procedure ap_data_get_object(v: Tvalue; AClass: TClass; var ret); stdcall;

implementation

uses uStrUtils;

{$I ruby_implement.pas}
{$I ruby_functions.pas}

procedure DefineSingletonMethod(klass: Tvalue; name: PChar; func1: TFunc1);
begin
  rb_define_singleton_method(klass, name, @func1, -1);
end;

procedure DefineMethod(klass: Tvalue; name: PChar; func1: TFunc1);
begin
  rb_define_method(klass, name, @func1, -1);
end;

procedure DefineAttrGet(klass: Tvalue; name: PChar; attr0: TAttr0);
begin
  rb_define_method(klass, name, @attr0, 0);
end;

procedure DefineAttrSet(klass: Tvalue; name: PChar; attr1: TAttr1);
begin
  rb_define_method(klass, PChar(joinEq(name)), @attr1, 1);
end;

procedure DefineModuleFunction(module: Tvalue; name: PChar; func1: TFunc1);
begin
  rb_define_module_function(module, name, @func1, -1);
end;

procedure DefineModuleAttrGet(module: Tvalue; name: PChar; attr0: TAttr0);
begin
  rb_define_module_function(module, name, @attr0, 0);
end;

procedure DefineModuleAttrSet(module: Tvalue; name: PChar; attr1: TAttr1);
begin
  rb_define_module_function(module, PChar(joinEq(name)), @attr1, 1);
end;

procedure ap_define_const(klass: Tvalue; const name: String; v: Tvalue);
begin
  rb_define_const(klass, PChar(UpperCase1(name)), v);
end;

procedure ap_data_get_object(v: Tvalue; AClass: TClass; var ret);
var
  Obj: TObject;
begin
  if v = Qnil then
    TObject(ret) := nil
  else
  begin
    Obj := ap_data_get_struct(v);
    if not (Obj is AClass) then
      ap_raise(ap_eArgError,
        Format('%s %s (expected %s)', [
           sWrong_arg_type,
           chopHead(Obj.ClassName),
           chopHead(AClass.ClassName)
        ]));
    TObject(ret) := Obj;
  end;
end;

end.
