unit PhiMainUnit;

interface

uses
  Types, SysUtils, Classes, QControls,
  QForms, QMenus,
  Rubies, PhiHandle, uStrUtils,
  version,
  uDebug, uCdecl, uHandle, uIntern, uAlloc, uProp,
  uPhi, uError, uIO, uPropInfo, uTypeInfo, uMarshal, uFunc, uThread,
  uShiftState,
  uFontCharset, uModalResult, uColor, uCursor,
  uPoint, uSize, uRect, uSizeConstraints, uDateTime,
  uSys,
  uStream, uStrings, uScreen, uClipboard,
  uIcon, uFont, uBrush, uPen,
  uDragObject, uCanvas, uBitmap,
  uPicture, uApplication,
  uComponent, uControl, uForm, uFrame, uMenuItem, uMenu,
  uLabel, uButton, uEdit, uMemo,
  uCheckBox, uRadioButton, uListBox,
  uComboBox, uScrollBar, uGroupBox, uRadioGroup, uPanel,
  uSpeedButton, uMaskEdit, uGrid, uImage, uShape, uScrollBox, uSplitter,
  uPageControl, uTabSheet,
  uTreeNode, uTreeView,
  uListItem, uListColumn, uListView,
  uStatusBar, uTimer, uPaintBox;

type
  TAllocFunc = function(var AControl): Tvalue;

procedure PhiTerminate; stdcall;
procedure PhiAliveTest; stdcall;
function PhiAlive: Boolean; stdcall;
procedure PhiBackTrace; stdcall;
procedure PhiFail; stdcall;
function PhiCallProtect(data: Tvalue): Tvalue; stdcall;
function PhiExport(S: string): Tvalue; stdcall;
procedure PhiSetStdoutProc(proc: TGetStrProc); stdcall;
procedure PhiSetGetsFunc(func: TRetStrFunc); stdcall;
procedure PhiSetGetcFunc(func: TRetChrFunc); stdcall;
procedure PhiSetInitProc(proc: TProcedure); stdcall;
procedure PhiLoadProtect(name: PChar; done: TNotifyEvent); stdcall;
procedure Init_phi; cdecl;

implementation

var
  alive_p: Boolean = False;
  InTerminate: Boolean = False;
  InAliveTest: Boolean = False;
  InThreadExit: Boolean = False;
  init_proc: TProcedure;
  Phi_mainloop_reenter: Boolean = False;

procedure PrintObjectList;
var
  i: Integer;
begin
  if @Stdout = nil then Exit;
  Stdout(PChar(Format('obj: %d'#10, [PhiObjectList.Count])));
  for i := 0 to PhiObjectList.Count-1 do
    Stdout(PChar(string(PhiObjectList[i].ClassName)+#10));
end;

procedure FormsClose;
var
  i: Integer;
  real: TForm;
  CloseEvent: TCloseEvent;
  CloseQueryEvent: TCloseQueryEvent;
begin
  i := 0;
  while True do
  begin
    i := PhiObjectList.FindInstanceOf(TForm, False, i);
    if i = -1 then Break;
    real := TForm(PhiObjectList[i]);
    CloseEvent := real.OnClose;
    CloseQueryEvent := real.OnCloseQuery;
    real.OnClose := nil;
    real.OnCloseQuery := nil;
    real.Close;
    real.OnCloseQuery := CloseQueryEvent;
    real.OnClose := CloseEvent;
    RemoveParentAttr(real);
    ClearEvents(real);
    Inc(i);
  end;
end;

procedure PhiTerminate; stdcall;
begin
  if InTerminate then Exit;
  InTerminate := True;
  alive_p := false;
  Handle.DoneThread(Application);
  FormsClose;
  rb_gc;
  if debug_p then PrintObjectList;
  if Screen.FormCount = 0 then Application.Terminate;
  InTerminate := False;
end;

procedure PhiAliveTest; stdcall;
var
  shown: Boolean;
  i: Integer;
begin
  if InAliveTest then Exit;
  InAliveTest := True;
  shown := False;

  i := 0;
  while True do
  begin
    i := PhiObjectList.FindInstanceOf(TForm, False, i);
    if i = -1 then Break;
    shown := shown or TForm(PhiObjectlist[i]).visible;
    Inc(i);
  end;
(*
  for i := 0 to Screen.FormCount-1 do
    shown := shown or Screen.Forms[i].visible;
*)
  if not shown then PhiTerminate;
  InAliveTest := False;
end;

function PhiAlive: Boolean; stdcall;
begin
  result := alive_p;
end;

function Phi_alive_p: Tvalue; cdecl;
begin
  result := ap_bool(alive_p);
end;

procedure PhiBackTrace; stdcall;
var
  ary: Tvalue;
  str: Tvalue;
  ptr: PChar;

  procedure ErrorInfo(info: Tvalue); cdecl;
  var
    ary, str: Tvalue;

    procedure Error;
    begin
      Stdout('fail to parse error info: ');
      rb_p(info);
    end;

    function IsType(v: Tvalue; t: Integer): Boolean;
    begin
      Result := RTYPE(v) = t;
      if not Result then Error;
    end;

  begin
    ary := rb_str_split(info, ':');
    str := rb_ary_shift(ary);
    if not IsType(str, T_STRING) then Exit;
    ErrorFile := ap_str_ptr(str);
    str := rb_ary_shift(ary);
    if not IsType(str, T_STRING) then Exit;
    if Length(ErrorFile) = 1 then
    begin
      ErrorFile := ErrorFile + ':' + ap_str_ptr(str);
      str := rb_ary_shift(ary);
    end;
    if RTYPE(str) <> T_STRING then Exit;
    try
      ErrorLine := StrToInt(ap_str_ptr(str));
    except
      on E: EConvertError do Error;
    end;
  end;

begin
  if (ap_errinfo = Qnil)
  or (rb_obj_is_kind_of(ap_errinfo, ap_eSystemExit) <> 0)
  then Exit;

  ErrorLine := 0; // ErrorLine = -1 if no error

  if (@Stdout = nil)
  then Exit;

  ary := rb_funcall2(ap_errinfo, rb_intern('backtrace'), 0, nil);
  str := rb_str_to_str(ap_errinfo);
  ptr := ap_str_ptr(str);
  Stdout(ptr);
  Stdout(#10);

  str := rb_ary_shift(ary);
  ErrorInfo(str);

  rb_ary_pop(ary);

  while str <> Qnil do
  begin
    Stdout('  ');
    Stdout(ap_str_ptr(str));
    Stdout(#10);
    str := rb_ary_shift(ary);
  end;

  ap_set_errinfo(Qnil);
end;

procedure PhiFail;
begin
  PhiBackTrace;
  PhiTerminate;
end;

function PhiEventCall(id: Tid; args: Tvalue): Tvalue;
var
  hash, key, obj, recv: Tvalue;
begin
  result := Qnil;
  hash := rb_iv_get(ap_ary_ptr(args)^, '@events');
  if RTYPE(hash) = T_HASH then
  begin
    key := INT2FIX(id);
    obj := rb_hash_aref(hash, key);
    if obj <> ap_hash_ifnone(hash) then
      result := rb_apply(obj, id_call, args)
    else
      result := Qnil
    ;
  end;
  if result = Qnil then
  begin
    recv := rb_ary_shift(args);
    if RTEST(recv) then
      result := rb_apply(recv, id, args)
    else
      result := Qnil
    ;
  end;
end;

function PhiCall(data: Tvalue): Tvalue; cdecl;
var
  id: Tvalue;
begin
  id := rb_ary_shift(data);
  result := PhiEventCall(id, data);
end;

function PhiCallProtect(data: Tvalue): Tvalue; stdcall;
var
  errno: Integer;
begin
  result := rb_protect(PhiCall, data, errno);
  if errno <> 0 then PhiFail;
end;

function GetAllocFunc(name: string): TAllocFunc;
var
  i: Integer;
begin
  i := PhiAllocFuncList.IndexOf(name);
  if i < 0 then
    result := nil
  else
    result := TAllocFunc(PhiAllocFuncList.Objects[i])
  ;
end;

procedure PhiLoadControls(real: TWinControl);
var
  i: Integer;
  func: TAllocFunc;
  name: string;
  This: Tvalue;
  obj: Tvalue;
  module: Tvalue;
  AControl: TControl;
begin
  This := real.tag;
  module := rb_iv_get(This, '@child_attr_module');
  if module = Qnil then Exit;

  for i := 0 to real.ControlCount-1 do
  begin
    AControl := real.Controls[i];
    name := AControl.ClassName;
    func := GetAllocFunc(name);
    if @func = nil then Continue;
    obj := func(AControl);

    if AControl.name = '' then
       AControl.name := LowerCase1(chopHead(AControl.ClassName)) + IntToStr(i);
    name := LowerCase1(AControl.name);
    rb_iv_set(This, PChar('@'+name), obj);
    rb_define_attr(module, PChar(name), 1, 0);

    rb_iv_set(obj, PChar('@parent'), This);

    if AControl is TWinControl then
      PhiLoadControls(TWinControl(AControl));
  end;
end;

procedure DefineMenuItem(real: TMenuItem);
var
  i: Integer;
  name: string;
  This: Tvalue;
  obj: Tvalue;
  module: Tvalue;
  item: TMenuItem;
begin
  This := real.tag;
  module := rb_iv_get(This, '@child_attr_module');
  if module = Qnil then Exit;
  if real.name = '' then
  try
    name := real.ClassName;
    if real.ComponentIndex = -1 then
       real.name := LowerCase1(chopHead(name))
    else
       real.name := LowerCase1(chopHead(name))
       + IntToStr(real.ComponentIndex);
  except
    on E: Exception do
      ap_raise(ap_eDelphiError, E.message);
  end;

  for i := 0 to real.Count-1 do
  begin
    item := real[i];
    obj := MenuItem_alloc(cMenuItem, item);

    name := LowerCase1(item.name);
    if name = '' then
    begin
      name := LowerCase1(chopHead(item.ClassName)) + IntToStr(i);
      item.name := name;
    end;
    rb_iv_set(This, PChar('@'+name), obj);
    rb_define_attr(module, PChar(name), 1, 0);

    DefineMenuItem(item);
  end;
end;

procedure DefineMenus(AForm: TForm);
begin
  with AForm do
  begin
    if menu = nil then Exit;
    rb_iv_set(tag, '@menu', MainMenu_alloc(cMainMenu, menu));
    DefineMenuItem(menu.items);
  end;
end;

procedure FormSetParams(AForm: TForm);
begin
  DefineMenus(AForm);
  FormSetParent(AForm, PChar(AForm.name));
end;

function PhiLoadForm(AForm: TForm): Tvalue;
var
  obj: Tvalue;
begin
  obj := Form_alloc(ap_cForm, AForm);
  PhiLoadControls(AForm);
  FormSetParams(AForm);
  result := obj;
end;

function PhiLoadComponent(Component: TComponent): Tvalue;
var
  name: string;
  func: TAllocFunc;
begin
  name := Component.ClassName;
  func := GetAllocFunc(name);
  if @func = nil then
    if Component is TForm then
      func := @Form_alloc
    else
    begin
      result := Qnil;
      Exit;
    end;
  result := func(Component);
  if Component is TWinControl then
    PhiLoadControls(TWinControl(Component));
  if Component is TForm then
    FormSetParams(TForm(Component));
  if Component.name = '' then
  try
    if Component.ComponentIndex = -1 then
       Component.name := LowerCase1(chopHead(name))
    else
       Component.name := LowerCase1(chopHead(name))
       + IntToStr(Component.ComponentIndex);
  except
    on E: Exception do
      ap_raise(ap_eDelphiError, E.message);
  end;
end;

function Stream_read_component(This: Tvalue): Tvalue; cdecl;
var
  real: TStream;
  Component: TComponent;
begin
  result := Qnil;
  real := ap_data_get_struct(This);
  try
    Component := real.ReadComponent(nil);
    result := PhiLoadComponent(Component);
  except
    on E: Exception do
      ap_raise(ap_eIOError, E.message);
  end;
end;

function Component_load(This, str: Tvalue): Tvalue; cdecl;
var
  Component: TComponent;
begin
  Component := StringToComponent(STR2CSTR(str));
  result := PhiLoadComponent(Component);
end;

function PhiExportFunc(top_module: Tvalue): Tvalue; cdecl;
var
  i: Integer;
  AForm: TForm;
  obj: Tvalue;
  name: string;
begin
  for i := 0 to Screen.FormCount-1 do
  begin
    AForm := Screen.Forms[i];
    name := chopHead(AForm.ClassName);
    if AForm.name = '' then
       AForm.name := name;
    obj := PhiLoadForm(AForm);
    rb_define_const(top_module, PChar(name), obj);
  end;
  result := Qnil;
end;

function PhiExport(S: string): Tvalue; stdcall;
var
  module: Tvalue;
  errno: Integer;
begin
  if Length(S) = 0 then begin result := Qnil; Exit end;
  module := rb_define_module(PChar(S));
  rb_protect(PhiExportFunc, module, errno);
  result := module;
end;

function Phi_export(This, str: Tvalue): Tvalue; cdecl;
begin
  result := PhiExport(StringOrSymbolToStr(str));
end;

procedure PhiSetStdoutProc(proc: TGetStrProc); stdcall;
begin
  Stdout := proc;
end;

procedure PhiSetGetsFunc(func: TRetStrFunc); stdcall;
begin
  gets := func;
end;

procedure PhiSetGetcFunc(func: TRetChrFunc); stdcall;
begin
  getc := func;
end;

procedure PhiSetInitProc(proc: TProcedure); stdcall;
begin
  init_proc := proc;
end;

procedure handle_message; cdecl;
begin
  if PhiAlive then
    Application.ProcessMessages
  else
    rb_exit(0)
  ;
end;

function Phi_mainloop(This: Tvalue): Tvalue; cdecl;
begin
  if Phi_mainloop_reenter then
    ap_raise(ap_eStandardError, 'duplicate mainloop');
  Phi_mainloop_reenter := True;
  try
    result := This;
    PhiAliveTest;
    while PhiAlive do
    begin
      Application.ProcessMessages
    end;
  finally
    Phi_mainloop_reenter := False;
  end
end;

function ap_load(fname: Tvalue): Tvalue; cdecl;
begin
  result := Qnil;
  try
    rb_load(fname, $10);
  except
    on E: Exception do
      ap_raise(eDelphiError, PChar(
        Format('%s (%s)', [E.message, E.ClassName])
      ));
  end;
end;

procedure ap_load_protect(fname: Tvalue; var state: Integer);
begin
  rb_protect(ap_load, fname, state);
end;

procedure PhiLoadProtect(name: PChar; done: TNotifyEvent); stdcall;
var
  state: Integer;
begin
  ErrorFile := '';
  ErrorLine := -1;
  alive_p := true;
  Handle.SetAppDoneThread(done);
  ruby_script(name);
  ap_load_protect(rb_str_new2(name), state);
  if state <> 0 then PhiBackTrace;
  if debug_p then PrintObjectList;
  PhiAliveTest;
end;

procedure Init_phi; cdecl;
begin
  DefineMethod(ap_cObject, 'initialize', retnil);

  alive_p := True;

  Init_intern;
  Init_phi_module;
  Init_error;
  Init_version;

  rb_define_module_function(mPhi, 'alive?', @Phi_alive_p, 0);
  rb_define_module_function(mPhi, 'mainloop', @Phi_mainloop, 0);
  rb_define_module_function(mPhi, 'undef_stdio', @Phi_undef_stdio, 0);
  rb_define_module_function(mPhi, 'export', @Phi_export, 1);

  Init_PropInfo;
  Init_TypeInfo;

  DefineConstSetType(mPhi, TypeInfo(TAlign));
  DefineConstSetType(mPhi, TypeInfo(TAlignment));
  DefineConstSetType(mPhi, TypeInfo(TAnchorKind));
  DefineConstSetType(mPhi, TypeInfo(TCloseAction));
  DefineConstSetType(mPhi, TypeInfo(TDragMode));
  DefineConstSetType(mPhi, TypeInfo(TBorderStyle));
  DefineConstSetType(mPhi, TypeInfo(TScrollBarKind));
  DefineConstSetType(mPhi, TypeInfo(TMouseButton));

  Init_Component;
  Init_Func;
  Init_Thread;

  Init_Color;
  Init_Cursor;
  Init_ShiftState;
  Init_FontCharset;
  Init_ModalResult;

  Init_Point;
  Init_Size;
  Init_Rect;
  Init_SizeConstraints;
  Init_DateTime;

  Init_Sys;

  Init_Stream;
  Init_Strings;
  Init_Screen;
  Init_Clipboard;
  Init_Icon;
  Init_Font;
  Init_Brush;
  Init_Pen;
  Init_DragObject;

  Init_Canvas;
  Init_Bitmap;
  Init_Picture;

  Init_Application;
  Init_Control;

  Init_Form;

  Init_Frame;
  Init_MenuItem;
  Init_Menu;
  Init_Label;
  Init_Button;
  Init_Edit;
  Init_Memo;
  Init_CheckBox;
  Init_RadioButton;
  Init_ListBox;
  Init_ComboBox;
  Init_ScrollBar;
  Init_GroupBox;
  Init_RadioGroup;
  Init_Panel;

  Init_SpeedButton;
  Init_MaskEdit;
  Init_Grid;
  Init_Image;
  Init_Shape;
  Init_ScrollBox;
  Init_Splitter;

  Init_PageControl;
  Init_TabSheet;
  Init_TreeNode;
  Init_TreeView;
  Init_ListItem;
  Init_ListColumn;
  Init_ListView;
  Init_StatusBar;

  Init_Timer;
  Init_PaintBox;

  rb_define_method(cStream, 'read_component', @Stream_read_component, 0);
  rb_define_singleton_method(cComponent, '_load', @Component_load, 1);

  if Assigned(init_proc) then init_proc;
end;

exports
  PhiTerminate,
  PhiAliveTest,
  PhiAlive,
  PhiBackTrace,
  PhiCallProtect,
  PhiExport,

  PhiSetStdoutProc,
  PhiSetGetsFunc,
  PhiSetGetcFunc,
  PhiSetInitProc,

  PhiLoadProtect,
  Init_phi;

procedure InitHandle;
begin
  Handle := TPhiHandle.Create(UOwner);
  Stdout := io_stdout;
  gets := io_gets;
  getc := io_getc;
end;

initialization
  InitHandle;

finalization
  Handle.Free;

end.
