unit PhiExternal;

interface

uses
  Types, SysUtils, Classes, QControls, QForms, QStdCtrls, QExtCtrls, contnrs,
  TypInfo, Rubies, PhiHandle, QGraphics, QMenus, QComCtrls, QButtons;

const
{$IFDEF LINUX}
  PhiDLL = 'phi.so';
{$ENDIF}
{$IFDEF WIN32}
  PhiDLL = 'phi.dll';
{$ENDIF}

function retnil(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
function retval(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;

function PhiErrorFile: string; stdcall;
function PhiErrorLine: Integer; stdcall;

function PhiExtentList: TObjectList; stdcall;
function PhiObjectList: TObjectList; stdcall;
function PhiAllocFuncList: TStringList; stdcall;
function PhiHandle: TPhiHandle; stdcall;

function ap_mPhi: Tvalue; stdcall;
function ap_mWin: Tvalue; stdcall;
function ap_mSys: Tvalue; stdcall;
function ap_eDelphiError: Tvalue; stdcall;

// Conv

function ap_Fixnum(v: Integer): Tvalue; stdcall;
function dl_Integer(v: Tvalue): Integer; stdcall;
function ap_Float(v: Double): Tvalue; stdcall;
function dl_Double(v: Tvalue): Double; stdcall;
function ap_String(S: string): Tvalue; stdcall;
function dl_String(v: Tvalue): string; stdcall;
function ap_Variant(A: Variant): Tvalue; stdcall;
function dl_Variant(A: Tvalue): Variant; stdcall;
function ap_set_to_ary(var v): Tvalue; stdcall;
function dl_ary_to_set(ary: Tvalue): Integer; stdcall;
function dl_ClassName(This: Tvalue): string; stdcall;

// Alloc

procedure ap_dispose(p: Pointer); cdecl;
procedure ObjFree(real: TObject); cdecl;
procedure ChildFree(real: TComponent); cdecl;
procedure CompoFree(real: TComponent); cdecl;
//procedure FormRelease(real: TForm); cdecl;
function CompoAlloc(klass: Tvalue; real: TComponent): Tvalue; stdcall;
function FormAlloc(klass: Tvalue; real: TComponent): Tvalue; stdcall;
function ChildAlloc(klass: Tvalue; real: TComponent): Tvalue; stdcall;
function ObjAlloc(klass: Tvalue; real: TObject): Tvalue; stdcall;
function TmpAlloc(klass: Tvalue; real: TObject): Tvalue; stdcall;

// Prop

procedure DefineAttrMethod(klass: Tvalue; name: PChar); stdcall;
procedure DefineAttrMethod_retval(klass: Tvalue; name: PChar); stdcall;
procedure DefineModuleAttrMethod(module: Tvalue; name: PChar); stdcall;
function GetEnumName0(TypeInfo: PTypeInfo; Value: Integer): string; stdcall;
function GetEnumProp0(Instance: TObject; PropInfo: PPropInfo): string; stdcall;
function GetEnumProp1(Instance: TObject; const PropName: string): string; stdcall;
function GetSetProp0(Instance: TObject; PropInfo: PPropInfo;
  Brackets: Boolean): string; stdcall;
function GetSetProp1(Instance: TObject; const PropName: string;
  Brackets: Boolean): string; stdcall;
function ap_get_str_prop(obj: TObject; const PropName: string; c: Char): Tvalue; stdcall;
procedure AssignPropMethod(Obj: TObject; Handles: array of TObject); stdcall;
procedure DefineProp(cClass: Tvalue; AClass: TClass); stdcall;
procedure DefineConstSetType(module: Tvalue; TypeInfo: PTypeInfo); stdcall;

// Component

procedure RemoveParentAttr(real: TComponent); stdcall;
function ap_cComponent: Tvalue; stdcall;
procedure CompoSetup(argc: integer; argv: Pointer; real: TComponent); stdcall;
function DefineCompoClass(module: Tvalue; AClass: TPersistentClass; super: Tvalue; func: TFuncAlloc_v): Tvalue; stdcall;

function ap_cPoint: Tvalue; stdcall;
function Point_alloc(This: Tvalue; real: TPoint): Tvalue; stdcall;
function ap_cSize: Tvalue; stdcall;
function Size_alloc(This: Tvalue; real: TSize): Tvalue; stdcall;
function ap_cRect: Tvalue; stdcall;
function Rect_alloc(This: Tvalue; real: TRect): Tvalue; stdcall;
function ap_cSizeConstraints: Tvalue; stdcall;
function SizeConstraints_alloc(This: Tvalue; real: TSizeConstraints): Tvalue; stdcall;
function ap_DateTime(v: TDateTime): Tvalue; stdcall;
function dl_DateTime(v: Tvalue): TDateTime; stdcall;
function ap_cDateTime: Tvalue; stdcall;
function DateTime_alloc(This: Tvalue; real: TDateTime): Tvalue; stdcall;

function ap_cStream: Tvalue; stdcall;
function ap_cStrings: Tvalue; stdcall;
function Strings_alloc(This: Tvalue; real: TStrings): Tvalue; stdcall;
function ap_cScreen: Tvalue; stdcall;
function ap_vScreen: Tvalue; stdcall;
function ap_cPicture: Tvalue; stdcall;
function Picture_alloc(This: Tvalue; real: TPicture): Tvalue; stdcall;
function ap_cIcon: Tvalue; stdcall;
function Icon_alloc(This: Tvalue; real: TIcon): Tvalue; stdcall;
function ap_cFont: Tvalue; stdcall;
function Font_alloc(This: Tvalue; real: TFont): Tvalue; stdcall;
function ap_cBrush: Tvalue; stdcall;
function Brush_alloc(This: Tvalue; real: TBrush): Tvalue; stdcall;
function ap_cPen: Tvalue; stdcall;
function Pen_alloc(This: Tvalue; real: TPen): Tvalue; stdcall;
function ap_cDragObject: Tvalue; stdcall;
function ap_cDragDockObject: Tvalue; stdcall;
function DragObject_alloc(This: Tvalue; real: TDragObject): Tvalue; stdcall;
//function DragDockObject_alloc(This: Tvalue; real: TDragDockObject): Tvalue; stdcall;

function ap_cCanvas: Tvalue; stdcall;
function Canvas_alloc(This: Tvalue; real: TCanvas): Tvalue; stdcall;
function ap_cBitmap: Tvalue; stdcall;
function Bitmap_alloc(This: Tvalue; real: TBitmap): Tvalue; stdcall;

function ap_cApplication: Tvalue; stdcall;
procedure ClearEvents(AControl: TControl); stdcall;
function ap_cControl: Tvalue; stdcall;
function ap_cWinControl: Tvalue; stdcall;

function ap_cForm: Tvalue; stdcall;
function Form_alloc(This: Tvalue; real: TForm): Tvalue; stdcall;

function ap_cMenuItem: Tvalue; stdcall;
function MenuItem_alloc(This: Tvalue; real: TMenuItem): Tvalue; stdcall;
function ap_cMainMenu: Tvalue; stdcall;
function MainMenu_alloc(This: Tvalue; real: TMainMenu): Tvalue; stdcall;
function ap_cPopupMenu: Tvalue; stdcall;
function PopupMenu_alloc(This: Tvalue; real: TPopupMenu): Tvalue; stdcall;
function ap_cLabel: Tvalue; stdcall;
function Label_alloc(This: Tvalue; real: TLabel): Tvalue; stdcall;
function ap_cEdit: Tvalue; stdcall;
function Edit_alloc(This: Tvalue; real: TEdit): Tvalue; stdcall;
function ap_cMemo: Tvalue; stdcall;
function Memo_alloc(This: Tvalue; real: TMemo): Tvalue; stdcall;
function ap_cButton: Tvalue; stdcall;
procedure Button_setup(obj: Tvalue; real: TButton);
function Button_alloc(This: Tvalue; real: TButton): Tvalue; stdcall;
function ap_cCheckBox: Tvalue; stdcall;
function CheckBox_alloc(This: Tvalue; real: TCheckBox): Tvalue; stdcall;
function ap_cRadioButton: Tvalue; stdcall;
function RadioButton_alloc(This: Tvalue; real: TRadioButton): Tvalue; stdcall;
function ap_cListBox: Tvalue; stdcall;
function ListBox_alloc(This: Tvalue; real: TListBox): Tvalue; stdcall;
function ap_cComboBox: Tvalue; stdcall;
function ComboBox_alloc(This: Tvalue; real: TComboBox): Tvalue; stdcall;
function ap_cScrollBar: Tvalue; stdcall;
function ScrollBar_alloc(This: Tvalue; real: TScrollBar): Tvalue; stdcall;
function ap_cGroupBox: Tvalue; stdcall;
function GroupBox_alloc(This: Tvalue; real: TGroupBox): Tvalue; stdcall;
function ap_cRadioGroup: Tvalue; stdcall;
function RadioGroup_alloc(This: Tvalue; real: TRadioGroup): Tvalue; stdcall;
function ap_cPanel: Tvalue; stdcall;
function Panel_alloc(This: Tvalue; real: TPanel): Tvalue; stdcall;

function ap_cSpeedButton: Tvalue; stdcall;
function SpeedButton_alloc(This: Tvalue; real: TSpeedButton): Tvalue; stdcall;

function ap_cCustomGrid: Tvalue; stdcall;
function ap_cDrawGrid: Tvalue; stdcall;
function ap_cStringGrid: Tvalue; stdcall;

function ap_cImage: Tvalue; stdcall;
function Image_alloc(This: Tvalue; real: TImage): Tvalue; stdcall;
function ap_cImageList: Tvalue; stdcall;
function ap_cSplitter: Tvalue; stdcall;
function Splitter_alloc(This: Tvalue; real: TSplitter): Tvalue; stdcall;

function ap_cTreeNode: Tvalue; stdcall;
function TreeNode_alloc(This: Tvalue; real: TTreeNode): Tvalue; stdcall;
function ap_cTreeNodes: Tvalue; stdcall;
function TreeNodes_alloc(This: Tvalue; real: TTreeNodes): Tvalue; stdcall;
function ap_cTreeView: Tvalue; stdcall;
function TreeView_alloc(This: Tvalue; real: TTreeView): Tvalue; stdcall;

function ap_cListItem: Tvalue; stdcall;
function ListItem_alloc(This: Tvalue; real: TListItem): Tvalue; stdcall;
function ap_cListItems: Tvalue; stdcall;
function ListItems_alloc(This: Tvalue; real: TListItems): Tvalue; stdcall;
function ap_cListColumn: Tvalue; stdcall;
function ListColumn_alloc(This: Tvalue; real: TListColumn): Tvalue; stdcall;
function ap_cListColumns: Tvalue; stdcall;
function ListColumns_alloc(This: Tvalue; real: TListColumns): Tvalue; stdcall;
function ap_cListView: Tvalue; stdcall;
function ListView_alloc(This: Tvalue; real: TListView): Tvalue; stdcall;

procedure PhiTerminate; stdcall;
procedure PhiAliveTest; stdcall;
function PhiAlive: Boolean; stdcall;
procedure PhiBackTrace; stdcall;
procedure PhiFail; stdcall;
function PhiCallProtect(data: Tvalue): Tvalue; stdcall;
function PhiExport(S: string): Tvalue; stdcall;

procedure PhiSetStdoutProc(Stdout: TGetStrProc); stdcall;
procedure PhiSetGetsFunc(func: TRetStrFunc); stdcall;
procedure PhiSetGetcFunc(func: TRetChrFunc); stdcall;
procedure PhiSetInitProc(proc: TProcedure); stdcall;

function StringOrSymbolToStr(v: Tvalue): PChar; stdcall;

procedure PhiLoadProtect(name: PChar; done: TNotifyEvent); stdcall;

implementation

function retnil(argc: integer; argv: Pointer; This: Tvalue): Tvalue; external PhiDLL;
function retval(argc: integer; argv: Pointer; This: Tvalue): Tvalue; external PhiDLL;

function PhiErrorFile: string; external PhiDLL;
function PhiErrorLine: Integer; external PhiDLL;

function PhiExtentList: TObjectList; external PhiDLL;
function PhiObjectList: TObjectList; external PhiDLL;
function PhiAllocFuncList: TStringList; external PhiDLL;
function PhiHandle: TPhiHandle; external PhiDLL;

function ap_mPhi: Tvalue; external PhiDLL;
function ap_mWin: Tvalue; external PhiDLL;
function ap_mSys: Tvalue; external PhiDLL;
function ap_eDelphiError: Tvalue; external PhiDLL;

function ap_Fixnum(v: Integer): Tvalue; external PhiDLL;
function dl_Integer(v: Tvalue): Integer; external PhiDLL;
function ap_Float(v: Double): Tvalue; external PhiDLL;
function dl_Double(v: Tvalue): Double; external PhiDLL;
function ap_String(S: string): Tvalue; external PhiDLL;
function dl_String(v: Tvalue): string; external PhiDLL;
function ap_Variant(A: Variant): Tvalue; external PhiDLL;
function dl_Variant(A: Tvalue): Variant; external PhiDLL;
function ap_set_to_ary(var v): Tvalue; external PhiDLL;
function dl_ary_to_set(ary: Tvalue): Integer; external PhiDLL;
function dl_ClassName(This: Tvalue): string; external PhiDLL;

procedure ap_dispose(p: Pointer); external PhiDLL;
procedure ObjFree(real: TObject); external PhiDLL;
procedure ChildFree(real: TComponent); external PhiDLL;
procedure CompoFree(real: TComponent); external PhiDLL;
procedure FormRelease(real: TForm); external PhiDLL;
function CompoAlloc(klass: Tvalue; real: TComponent): Tvalue; external PhiDLL;
function FormAlloc(klass: Tvalue; real: TComponent): Tvalue; external PhiDLL;
function ChildAlloc(klass: Tvalue; real: TComponent): Tvalue; external PhiDLL;
function ObjAlloc(klass: Tvalue; real: TObject): Tvalue; external PhiDLL;
function TmpAlloc(klass: Tvalue; real: TObject): Tvalue; external PhiDLL;

procedure DefineAttrMethod(klass: Tvalue; name: PChar); external PhiDLL;
procedure DefineAttrMethod_retval(klass: Tvalue; name: PChar); external PhiDLL;
procedure DefineModuleAttrMethod(module: Tvalue; name: PChar); external PhiDLL;
function GetEnumName0(TypeInfo: PTypeInfo; Value: Integer): string; external PhiDLL;
function GetEnumProp0(Instance: TObject; PropInfo: PPropInfo): string; external PhiDLL;
function GetEnumProp1(Instance: TObject; const PropName: string): string; external PhiDLL;
function GetSetProp0(Instance: TObject; PropInfo: PPropInfo;
  Brackets: Boolean): string; external PhiDLL;
function GetSetProp1(Instance: TObject; const PropName: string;
  Brackets: Boolean): string; external PhiDLL;
function ap_get_str_prop(obj: TObject; const PropName: string; c: Char): Tvalue; external PhiDLL;
procedure AssignPropMethod(Obj: TObject; Handles: array of TObject); external PhiDLL;
procedure DefineProp(cClass: Tvalue; AClass: TClass); external PhiDLL;
procedure DefineConstSetType(module: Tvalue; TypeInfo: PTypeInfo); external PhiDLL;

procedure RemoveParentAttr(real: TComponent); external PhiDLL;
function ap_cComponent: Tvalue; external PhiDLL;
procedure CompoSetup(argc: integer; argv: Pointer; real: TComponent); external PhiDLL;
function DefineCompoClass(module: Tvalue; AClass: TPersistentClass; super: Tvalue; func: TFuncAlloc_v): Tvalue; external PhiDLL;

function ap_cPoint: Tvalue; external PhiDLL;
function Point_alloc(This: Tvalue; real: TPoint): Tvalue; external PhiDLL;
function ap_cSize: Tvalue; external PhiDLL;
function Size_alloc(This: Tvalue; real: TSize): Tvalue; external PhiDLL;
function ap_cRect: Tvalue; external PhiDLL;
function Rect_alloc(This: Tvalue; real: TRect): Tvalue; external PhiDLL;
function ap_cSizeConstraints: Tvalue; external PhiDLL;
function SizeConstraints_alloc(This: Tvalue; real: TSizeConstraints): Tvalue; external PhiDLL;
function ap_DateTime(v: TDateTime): Tvalue; external PhiDLL;
function dl_DateTime(v: Tvalue): TDateTime; external PhiDLL;
function ap_cDateTime: Tvalue; external PhiDLL;
function DateTime_alloc(This: Tvalue; real: TDateTime): Tvalue; external PhiDLL;

function ap_cStream: Tvalue; external PhiDLL;
function ap_cStrings: Tvalue; external PhiDLL;
function Strings_alloc(This: Tvalue; real: TStrings): Tvalue; external PhiDLL;
function ap_cScreen: Tvalue; external PhiDLL;
function ap_vScreen: Tvalue; external PhiDLL;
function ap_cPicture: Tvalue; external PhiDLL;
function Picture_alloc(This: Tvalue; real: TPicture): Tvalue; external PhiDLL;
function ap_cIcon: Tvalue; external PhiDLL;
function Icon_alloc(This: Tvalue; real: TIcon): Tvalue; external PhiDLL;
function ap_cFont: Tvalue; external PhiDLL;
function Font_alloc(This: Tvalue; real: TFont): Tvalue; external PhiDLL;
function ap_cBrush: Tvalue; external PhiDLL;
function Brush_alloc(This: Tvalue; real: TBrush): Tvalue; external PhiDLL;
function ap_cPen: Tvalue; external PhiDLL;
function Pen_alloc(This: Tvalue; real: TPen): Tvalue; external PhiDLL;
function ap_cDragObject: Tvalue; external PhiDLL;
function ap_cDragDockObject: Tvalue; external PhiDLL;
function DragObject_alloc(This: Tvalue; real: TDragObject): Tvalue; external PhiDLL;
//function DragDockObject_alloc(This: Tvalue; real: TDragDockObject): Tvalue;  external PhiDLL;

function ap_cCanvas: Tvalue; external PhiDLL;
function Canvas_alloc(This: Tvalue; real: TCanvas): Tvalue; external PhiDLL;
function ap_cBitmap: Tvalue; external PhiDLL;
function Bitmap_alloc(This: Tvalue; real: TBitmap): Tvalue; external PhiDLL;

function ap_cApplication: Tvalue; external PhiDLL;
procedure ClearEvents(AControl: TControl); external PhiDLL;
function ap_cControl: Tvalue; external PhiDLL;
function ap_cWinControl: Tvalue; external PhiDLL;

function ap_cForm: Tvalue; external PhiDLL;
function Form_alloc(This: Tvalue; real: TForm): Tvalue; external PhiDLL;

function ap_cMenuItem: Tvalue; external PhiDLL;
function MenuItem_alloc(This: Tvalue; real: TMenuItem): Tvalue; external PhiDLL;
function ap_cMainMenu: Tvalue; external PhiDLL;
function MainMenu_alloc(This: Tvalue; real: TMainMenu): Tvalue; external PhiDLL;
function ap_cPopupMenu: Tvalue; external PhiDLL;
function PopupMenu_alloc(This: Tvalue; real: TPopupMenu): Tvalue; external PhiDLL;
function ap_cLabel: Tvalue; external PhiDLL;
function Label_alloc(This: Tvalue; real: TLabel): Tvalue; external PhiDLL;
function ap_cEdit: Tvalue; external PhiDLL;
function Edit_alloc(This: Tvalue; real: TEdit): Tvalue; external PhiDLL;
function ap_cMemo: Tvalue; external PhiDLL;
function Memo_alloc(This: Tvalue; real: TMemo): Tvalue; external PhiDLL;
function ap_cButton: Tvalue; external PhiDLL;
procedure Button_setup(obj: Tvalue; real: TButton); external PhiDLL;
function Button_alloc(This: Tvalue; real: TButton): Tvalue; external PhiDLL;
function ap_cCheckBox: Tvalue; external PhiDLL;
function CheckBox_alloc(This: Tvalue; real: TCheckBox): Tvalue; external PhiDLL;
function ap_cRadioButton: Tvalue; external PhiDLL;
function RadioButton_alloc(This: Tvalue; real: TRadioButton): Tvalue; external PhiDLL;
function ap_cListBox: Tvalue; external PhiDLL;
function ListBox_alloc(This: Tvalue; real: TListBox): Tvalue; external PhiDLL;
function ap_cComboBox: Tvalue; external PhiDLL;
function ComboBox_alloc(This: Tvalue; real: TComboBox): Tvalue; external PhiDLL;
function ap_cScrollBar: Tvalue; external PhiDLL;
function ScrollBar_alloc(This: Tvalue; real: TScrollBar): Tvalue; external PhiDLL;
function ap_cGroupBox: Tvalue; external PhiDLL;
function GroupBox_alloc(This: Tvalue; real: TGroupBox): Tvalue; external PhiDLL;
function ap_cRadioGroup: Tvalue; external PhiDLL;
function RadioGroup_alloc(This: Tvalue; real: TRadioGroup): Tvalue; external PhiDLL;
function ap_cPanel: Tvalue; external PhiDLL;
function Panel_alloc(This: Tvalue; real: TPanel): Tvalue; external PhiDLL;

function ap_cSpeedButton: Tvalue; external PhiDLL;
function SpeedButton_alloc(This: Tvalue; real: TSpeedButton): Tvalue; external PhiDLL;

function ap_cCustomGrid: Tvalue; external PhiDLL;
function ap_cDrawGrid: Tvalue; external PhiDLL;
function ap_cStringGrid: Tvalue; external PhiDLL;

function ap_cImage: Tvalue; external PhiDLL;
function Image_alloc(This: Tvalue; real: TImage): Tvalue; external PhiDLL;
function ap_cImageList: Tvalue; external PhiDLL;
function ap_cSplitter: Tvalue; external PhiDLL;
function Splitter_alloc(This: Tvalue; real: TSplitter): Tvalue; external PhiDLL;

function ap_cTreeNode: Tvalue; external PhiDLL;
function TreeNode_alloc(This: Tvalue; real: TTreeNode): Tvalue; external PhiDLL;
function ap_cTreeNodes: Tvalue; external PhiDLL;
function TreeNodes_alloc(This: Tvalue; real: TTreeNodes): Tvalue; external PhiDLL;
function ap_cTreeView: Tvalue; external PhiDLL;
function TreeView_alloc(This: Tvalue; real: TTreeView): Tvalue; external PhiDLL;

function ap_cListItem: Tvalue; external PhiDLL;
function ListItem_alloc(This: Tvalue; real: TListItem): Tvalue; external PhiDLL;
function ap_cListItems: Tvalue; external PhiDLL;
function ListItems_alloc(This: Tvalue; real: TListItems): Tvalue; external PhiDLL;
function ap_cListColumn: Tvalue; external PhiDLL;
function ListColumn_alloc(This: Tvalue; real: TListColumn): Tvalue; external PhiDLL;
function ap_cListColumns: Tvalue; external PhiDLL;
function ListColumns_alloc(This: Tvalue; real: TListColumns): Tvalue; external PhiDLL;
function ap_cListView: Tvalue; external PhiDLL;
function ListView_alloc(This: Tvalue; real: TListView): Tvalue; external PhiDLL;

procedure PhiTerminate; external PhiDLL;
procedure PhiAliveTest; external PhiDLL;
function PhiAlive: Boolean; external PhiDLL;
procedure PhiBackTrace; external PhiDLL;
procedure PhiFail; external PhiDLL;
function PhiCallProtect(data: Tvalue): Tvalue; external PhiDLL;
function PhiExport(S: string): Tvalue; external PhiDLL;

procedure PhiSetStdoutProc(Stdout: TGetStrProc); external PhiDLL;
procedure PhiSetGetsFunc(func: TRetStrFunc); external PhiDLL;
procedure PhiSetGetcFunc(func: TRetChrFunc); external PhiDLL;
procedure PhiSetInitProc(proc: TProcedure); external PhiDLL;

function StringOrSymbolToStr(v: Tvalue): PChar; external PhiDLL;

procedure PhiLoadProtect(name: PChar; done: TNotifyEvent); external PhiDLL;

end.
